/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import com.urbancode.air.plugin.command.version.rollback.RiskyArtifact;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class RollbackManifestGenerator {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private final List<RiskyArtifact> artifactsToBeSkipped;
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private RollbackManifestGenerator(List<RiskyArtifact> overlappingArtifacts) {
        this.artifactsToBeSkipped = overlappingArtifacts;
    }

    public static String generateInvertedActionsXml(String inputManifestPath) throws XMLStreamException, IOException {
        return RollbackManifestGenerator.generateInvertedActionsXml(inputManifestPath, new ArrayList<RiskyArtifact>());
    }

    public static String generateInvertedActionsXml(String inputManifestPath, List<RiskyArtifact> overlappingArtifacts) throws XMLStreamException, IOException {
        RollbackManifest rollbackManifest = RollbackManifest.from((String)inputManifestPath);
        return new RollbackManifestGenerator(overlappingArtifacts).createXML(rollbackManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createXML(RollbackManifest rollbackManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(rollbackManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(RollbackManifest rollbackManifest) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeStartElement("manifest");
        if (rollbackManifest.getVersion() != null) {
            this.xmlStreamWriter.writeAttribute("version", rollbackManifest.getVersion());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        List<RollbackContainer> updatedContainers = this.getContainersAfterSkippingRiskyArtifacts(rollbackManifest.getUpdatedContainers());
        List<RollbackContainer> deletedContainers = this.getContainersAfterSkippingRiskyArtifacts(rollbackManifest.getDeletedContainers());
        this.writeDeployContainers(updatedContainers, deletedContainers);
        if (!rollbackManifest.getCreatedContainers().isEmpty()) {
            List<RollbackContainer> createdContainers = this.getContainersAfterSkippingRiskyArtifacts(rollbackManifest.getCreatedContainers());
            this.writeDeletedContainers(createdContainers);
        }
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeDeployContainers(List<RollbackContainer> updatedContainers, List<RollbackContainer> deletedContainers) throws XMLStreamException {
        HashSet<String> writtenContainers = new HashSet<String>();
        for (RollbackContainer updatedContainer : updatedContainers) {
            this.writeContainerStartElement(updatedContainer);
            for (RollbackResource updatedContainerResource : updatedContainer.getResources()) {
                this.writeDeployContainerResource(updatedContainerResource);
            }
            Optional<RollbackContainer> deletedContainer = this.getDeletedContainerWithSameNameAndType(updatedContainer, deletedContainers);
            boolean isSameContainerPresentUnderDeletedTag = deletedContainer.isPresent();
            if (isSameContainerPresentUnderDeletedTag) {
                this.writeResourcesOfDeletedContainerUnderUpdatedContainer(deletedContainer.get());
            }
            this.writeEndElement();
            writtenContainers.add(updatedContainer.getName());
        }
        for (RollbackContainer deletedContainer : deletedContainers) {
            boolean isDeletedContainerAlreadyWritten = writtenContainers.contains(deletedContainer.getName());
            if (isDeletedContainerAlreadyWritten) continue;
            this.writeDeletedDeployContainer(deletedContainer);
        }
    }

    private void writeResourcesOfDeletedContainerUnderUpdatedContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        for (RollbackResource deletedContainerResource : deletedContainer.getResources()) {
            this.writeDeployContainerResource(deletedContainerResource);
        }
    }

    private Optional<RollbackContainer> getDeletedContainerWithSameNameAndType(RollbackContainer updatedContainer, List<RollbackContainer> deletedContainers) {
        return deletedContainers.stream().filter(rollbackContainer -> !rollbackContainer.isMissing()).filter(rollbackContainer -> rollbackContainer.getName().equals(updatedContainer.getName())).filter(rollbackContainer -> rollbackContainer.getType() == updatedContainer.getType()).findFirst();
    }

    private void writeDeletedDeployContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        if (deletedContainer.isMissing()) {
            return;
        }
        ContainerType type = deletedContainer.getType();
        if ((type == ContainerType.PDS || type == ContainerType.DIRECTORY) && this.isAllContainerResourcesMissing(deletedContainer)) {
            return;
        }
        this.writeContainerStartElement(deletedContainer);
        for (RollbackResource deployContainerResource : deletedContainer.getResources()) {
            this.writeDeployContainerResource(deployContainerResource);
        }
        this.writeEndElement();
    }

    private boolean isAllContainerResourcesMissing(RollbackContainer container) {
        return container.getResources().stream().allMatch(RollbackResource::isMissing);
    }

    private void writeDeployContainerResource(RollbackResource deployContainerResource) throws XMLStreamException {
        if (deployContainerResource.isMissing()) {
            return;
        }
        this.writeContainerResource(deployContainerResource);
    }

    private void writeDeletedContainers(List<RollbackContainer> containers) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (RollbackContainer deletedContainer : containers) {
            this.writeDeletedContainer(deletedContainer);
        }
        this.writeEndElement();
    }

    private void writeDeletedContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", deletedContainer.getName());
        this.xmlStreamWriter.writeAttribute("type", this.getContainerType(deletedContainer.getType()));
        if (deletedContainer.isMissing()) {
            this.xmlStreamWriter.writeAttribute("missing", "true");
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (RollbackResource deletedContainerResource : deletedContainer.getResources()) {
            this.writeContainerResource(deletedContainerResource);
        }
        this.writeEndElement();
    }

    private void writeContainerStartElement(RollbackContainer container) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", container.getName());
        this.xmlStreamWriter.writeAttribute("type", this.getContainerType(container.getType()));
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainerResource(RollbackResource resource) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement("resource");
        this.xmlStreamWriter.writeAttribute("name", resource.getName());
        this.xmlStreamWriter.writeAttribute("type", resource.getType());
        if (resource.getModifiedUser() != null && resource.getModifiedTimestamp() != null) {
            this.xmlStreamWriter.writeAttribute("lastModifiedUserid", resource.getModifiedUser());
            this.xmlStreamWriter.writeAttribute("lastModifiedTimestamp", resource.getModifiedTimestamp());
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private String getContainerType(ContainerType type) {
        switch (type) {
            case PDS: {
                return "PDS";
            }
            case SEQUENTIAL: {
                return "sequential";
            }
            case DIRECTORY: {
                return "directory";
            }
        }
        throw new IllegalArgumentException("Unsupported Container Type found " + type);
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private List<RollbackContainer> getContainersAfterSkippingRiskyArtifacts(List<RollbackContainer> containers) {
        ArrayList<RollbackContainer> containersWithoutRiskyArtifacts = new ArrayList<RollbackContainer>();
        for (RollbackContainer container : containers) {
            if (container.getType() == ContainerType.SEQUENTIAL) {
                if (this.artifactsToBeSkipped.contains(new RiskyArtifact(container.getName(), ContainerType.SEQUENTIAL))) {
                    System.out.println("[INFO] Sequential container " + container.getName() + " is risky and will be skipped.");
                    continue;
                }
                containersWithoutRiskyArtifacts.add(container);
                continue;
            }
            if (container.getType() != ContainerType.PDS && container.getType() != ContainerType.DIRECTORY) continue;
            for (RollbackResource resource : container.getResources()) {
                if (this.isResourceRisky(container, resource, this.artifactsToBeSkipped)) {
                    System.out.println("[INFO] Resource " + resource.getName() + " in container " + container.getName() + " is risky and will be skipped.");
                    continue;
                }
                Optional<RollbackContainer> existingContainer = this.getContainerIfPresentInNonRiskyList(containersWithoutRiskyArtifacts, container);
                if (existingContainer.isPresent()) {
                    existingContainer.get().addResource(resource);
                    continue;
                }
                RollbackContainer rollbackContainer = RollbackManifestGenerator.generateRollbackContainerFromAnother(container);
                rollbackContainer.addResource(resource);
                containersWithoutRiskyArtifacts.add(rollbackContainer);
            }
        }
        return containersWithoutRiskyArtifacts;
    }

    private static RollbackContainer generateRollbackContainerFromAnother(RollbackContainer container) {
        RollbackContainer rollbackContainer = new RollbackContainer(container.getName(), container.getType());
        if (container.isMissing()) {
            rollbackContainer.setMissing();
        }
        if (container.getDeployType() != null) {
            rollbackContainer.setDeployType(container.getDeployType());
        }
        return rollbackContainer;
    }

    private boolean isResourceRisky(RollbackContainer container, RollbackResource resource, List<RiskyArtifact> artifactsToBeSkipped) {
        return artifactsToBeSkipped.stream().anyMatch(riskyArtifact -> riskyArtifact.getTargetName().equals(container.getName()) && riskyArtifact.getContainerType() == container.getType() && riskyArtifact.getResources().contains(resource.getName()));
    }

    private Optional<RollbackContainer> getContainerIfPresentInNonRiskyList(List<RollbackContainer> containersWithoutRiskyArtifacts, RollbackContainer container) {
        return containersWithoutRiskyArtifacts.stream().filter(rc -> rc.getName().equals(container.getName()) && rc.getType() == container.getType()).findFirst();
    }
}

