/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;

public final class InputsValidator {
    private static final int MAX_LENGTH_FOR_DSN_PREFIX = 17;

    private InputsValidator() {
    }

    public static void checkIfEmpty(String inputValue, String inputName) {
        if (inputValue.isEmpty()) {
            throw new MissingInputException(inputName + " cannot be empty.");
        }
    }

    public static void checkForPositiveInteger(String inputValue, String inputName) {
        int number = Integer.parseInt(inputValue);
        if (number < 0) {
            throw new InvalidInputException(inputName + " must be a positive integer");
        }
    }

    public static void checkDsnPrefixLength(String dsnPrefix) {
        if (dsnPrefix.length() > 17) {
            throw new InvalidInputException("DSN Prefix '" + dsnPrefix + "' is more than " + 17 + " characters.");
        }
    }
}

