/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.generate.artifact.info.Filters;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.util.HashMap;

final class Console {
    private Console() {
    }

    public static void printFilters(Filters filters) {
        String deploymentAction = filters.getDeploymentAction() == null ? "" : filters.getDeploymentAction().toString();
        System.out.println("Filter: [Container:" + filters.getSourceContainer() + " TargetDataset:" + filters.getTargetDataset() + " Resource:" + filters.getResource() + " DeployType:" + filters.getDeployType() + " DeploymentAction:" + deploymentAction + " CustomProperties:" + filters.getCustomProperties() + "]");
        System.out.println();
    }

    public static void printContainerInfo(Container container, String targetName) {
        System.out.println("Apply filter to ContainerType=" + container.getType().toString() + " Source=" + container.getSourceContainerName() + " Target=" + targetName + " DeployType=" + container.getDeployType() + " Deleted=" + container.isDeleted() + " CustomProperties=" + container.getCustomerProperties());
    }

    public static void printContainerResourceInfo(Container container, String targetName, Resource resource) {
        HashMap<String, String> customProperties = new HashMap<String, String>();
        customProperties.putAll(resource.getCustomerProperties());
        customProperties.putAll(container.getCustomerProperties());
        String deployType = Console.getDeployType(resource);
        System.out.println("Apply Filter to ContainerType=" + container.getType().toString() + " Source=" + container.getSourceContainerName() + " Target=" + targetName + " Resource=" + resource.getName() + " DeployType=" + deployType + " Deleted=" + container.isDeleted() + " CustomProperties=" + customProperties);
    }

    private static String getDeployType(Resource resource) {
        return resource.getResourceDeployType() != null ? resource.getResourceDeployType() : resource.getContainerDeployType();
    }
}

