/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
parse arg actionDataset

CODE_8 = 8

/* Read Action records into a stem variable */
drop actionRecords.
Address TSO "ALLOC F(ACTNDSN)  DA('"actionDataset"') SHR REUSE"
Address TSO "EXECIO * DISKR ACTNDSN (STEM actionRecords. FINIS)"
exec_RC = rc
x = Msg('off')
    Address TSO "FREE F(ACTNDSN)"
x = Msg('on')
if exec_RC <> 0 then do
    say " [Error] EXECIO failed for dataset" actionDataset "with rc" exec_RC
    call ExitProgram(exec_RC)
end

/* Main Process */
/* Reading Action dataset records one by one and process it */
/* Note : The offset starts from 2nd line as 1st line is header */
do offset = 1 to actionRecords.0
    parse upper var actionRecords.offset DSNtype ";" Action ";" SrceDSN ";" TargDSN ";" PDSmem .
    Select
        when ( Action == "DELETE" & DSNtype == "PDS" ) then
            call DeletePdsMembers
        when ( Action == "DELETE" & DSNtype == "SEQ" ) then
            call DeleteDataset TargDSN
        otherwise do
            say " [Error] Invalid Action record found -" actionRecords.offset
            Call ExitProgram(CODE_8)
        end
    end
    say ''
end

exit /* End of Program */

/**********************************************************************
*********          FUNCTIONS START FROM HERE                ***********
**********************************************************************/
DeleteDataset:procedure
   parse arg targetDataset

   x = OUTTRAP('DELSEQMSG.')
      Address TSO "DELETE '"targetDataset"'"
      Del_rc = rc
   x = OUTTRAP('OFF')

   parse upper var DELSEQMSG.1 IDC_Code IDC_Msg
   select
     when IDC_Code == "IDC0550I" then
        say 'Deleted dataset' targetDataset
     when IDC_Code == "IDC3012I" then
        say 'Deletion of dataset' targetDataset 'skipped as dataset does not exist.'
     otherwise do
        /* Display SYSTEM error messages before exiting the program */
        do z = 1 to DELSEQMSG.0
           say DELSEQMSG.z
        end
        call ExitProgram(Del_rc)
     end
   end

return

DeletePdsMembers:
  /* Deleting requested MEMBER from a PDS Data set.
     Sequence of actions performed in this function are :

                1) LMINIT
                2) LMOPEN
                3) LMMDEL
                4) LMCLOSE
                5) LMFREE
  */
   Address ISPEXEC "LMINIT DATAID(DOD) DATASET('"TargDSN"') ENQ(SHRW)"
    if rc <> 0 then do
        say "The LMINIT function failed for dataset" TargDSN "with return code :" rc
        Call ExitProgram(rc)
    end

   Address ISPEXEC "LMOPEN DATAID(&DOD) OPTION(OUTPUT)"
   Open_rc = rc
   If (Open_rc <> 0) then do
      say "The LMOPEN function failed for dataset" TargDSN "with return code :" Open_rc
      call freeDataset
      call ExitProgram(Open_rc)
   end

   /* Start reading Action records one by one from where its leftoff */
   do forever
      Address ISPEXEC "LMMDEL DATAID(&DOD) MEMBER("PDSmem")"
      lmdel_RC = rc

      Select
        When (lmdel_RC == 0) Then
            say 'Deleted PDS member' TargDSN'('PDSmem')'
        When (lmdel_RC == 8) Then
            Say "Deletion of PDS Member" TargDSN"("PDSmem") skipped as member does not exist."
        otherwise do
          say "The deletion of the member" PDSmem "failed with return code :" lmdel_RC
          call closeDataset
          call freeDataset
          call ExitProgram(lmdel_RC)
        end
      end /* End of SELECT statement */

      if ( offset == actionRecords.0 ) then leave

      offset = offset + 1

      parse upper var actionRecords.offset cDSNtype ";" cAction ";" cSrceDSN ";" cTargDSN ";" cPDSmem .

      if ( DSNtype <> cDSNtype | Action <> cAction | TargDSN <> cTargDSN ) then do
          offset = offset - 1 ; leave
      end

      DSNtype =  cDSNtype ; Action  =  cAction
      TargDSN =  cTargDSN ; PDSmem  =  cPDSmem

   end /* End of DO Loop */

   call closeDataset
   call freeDataset

return /* End of Function DeletePdsMembers */

closeDataset:

   Address ISPEXEC "LMCLOSE DATAID(&DOD)"
   if rc <> 0 then do
      say "The LMCLOSE function failed with return code :" rc
      call ExitProgram(rc)
   end

return

freeDataset:

   Address ISPEXEC "LMFREE DATAID(&DOD)"
   if rc <> 0 then do
      say "The LMFREE function failed with return code :" rc
      call ExitProgram(rc)
   end

return

ExitProgram:procedure
    Parse arg returnCode
    ZISPFRC = returnCode
    Address ISPEXEC "VPUT (ZISPFRC) SHARED"
Exit returnCode
