/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class LogConfigurator {
    private static final HashMap<Class<?>, Level> loggerMap = new HashMap();
    private static final int MAX_TOKENS_POST_SPLIT = 2;
    private static final Predicate<String> isValidJavaClass = className -> {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            System.out.println("[WARNING] Unable to get Java Class for provided class name " + className);
            return false;
        }
    };
    private static final Predicate<String> isValidLoggingLevel = logLevel -> {
        for (Level level : Level.values()) {
            if (!logLevel.equals(level.name())) continue;
            return true;
        }
        System.out.println(" [WARNING] Invalid Log Level " + logLevel + " passed. Valid Log Levels are " + Arrays.toString(Level.values()));
        return false;
    };

    public static void addClassesToLoggerMap(String classesWithLogLevel) {
        Stream.of(classesWithLogLevel.split("\n")).map(line -> line.split("=", 2)).filter(LogConfigurator::isValidInput).forEach(LogConfigurator::addClassToLoggerMap);
    }

    public static Logger configureLogger(Class<?> className) {
        Logger logger = LogManager.getLogger(className);
        Configurator.setLevel((Logger)logger, (Level)loggerMap.getOrDefault(className, Level.INFO));
        return logger;
    }

    private static boolean isValidInput(String[] classNameLogLevel) {
        return classNameLogLevel.length == 2 & isValidJavaClass.test(classNameLogLevel[0]) & isValidLoggingLevel.test(classNameLogLevel[1]);
    }

    private static void addClassToLoggerMap(String[] parts) {
        try {
            loggerMap.put(Class.forName(parts[0]), Level.toLevel((String)parts[1]));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

