/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.rexx;

import com.ibm.team.enterprise.automation.ispf.IspfPermissionsChecker;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import com.ibm.urbancode.zos.rexx.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.rexx.RexxNonZeroRcException;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class RexxExecutor {
    private static final String TSO_EX = "TSO EX";
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private final String dsnPrefix;
    private final String ispfGatewayBinariesPath;

    public RexxExecutor(String dsnPrefix, String ispfGatewayBinariesPath) {
        this.dsnPrefix = dsnPrefix;
        this.ispfGatewayBinariesPath = ispfGatewayBinariesPath;
    }

    public void execute(String rexxFilePath, String rexxArguments) throws Exception {
        IspfGatewayXMLResponse ispfGatewayXMLResponse = this.executeProgram(rexxFilePath, rexxArguments);
        if (ispfGatewayXMLResponse.getOutputText().isPresent()) {
            Console.printProcessOutput((String)ispfGatewayXMLResponse.getOutputText().get());
        } else {
            this.printIspfGatewayResponse(ispfGatewayXMLResponse);
        }
        if (ispfGatewayXMLResponse.getReturnCode() > 0) {
            Path path = Paths.get(rexxFilePath, new String[0]);
            String rexxProgram = path.getFileName().toString();
            throw new RexxNonZeroRcException("Program " + rexxProgram + " failed, check ISPF logs.");
        }
    }

    private void printIspfGatewayResponse(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        Console.printActionTitle("ISPF Gateway Operation log:");
        System.out.println(ispfGatewayXMLResponse.getOperationsLog());
        Console.printActionTitle("ISPF Gateway Reason Codes:");
        for (String reasonCode : ispfGatewayXMLResponse.getReasonCodeList()) {
            System.out.println(reasonCode);
        }
        Console.printActionTitle("ISPF Gateway Return Code: " + ispfGatewayXMLResponse.getReturnCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IspfGatewayXMLResponse executeProgram(String rexxFilePath, String rexxArguments) throws Exception {
        String rexxDataset = TempDsnNameHelper.getRexxDsnName(this.dsnPrefix);
        try {
            RexxFileToDatasetConvertor.convert(rexxFilePath, rexxDataset);
            IspfPermissionsChecker.checkDirectoryFilePermissions();
            String command = this.buildCommandForIspfGateway(rexxDataset, rexxArguments);
            IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(ServiceType.ISPF, command);
            IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayBinariesPath, this.dsnPrefix);
            IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute(ispfGatewayXMLInput);
            return ispfGatewayXMLResponse;
        }
        finally {
            DatasetHelper.deleteDataset(rexxDataset);
        }
    }

    private String buildCommandForIspfGateway(String rexxDataset, String rexxArguments) {
        return "TSO EX '" + rexxDataset + SINGLE_QUOTE + SPACE + SINGLE_QUOTE + rexxArguments + SINGLE_QUOTE;
    }
}

