/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.copy.dataset;

class IncludeMember {
    private static final String REPLACE_OPTION = "R";
    private static final String COMMA = ",";
    private static final String DOUBLE_OPEN_PARENTHESIS = "((";
    private static final String DOUBLE_CLOSED_PARENTHESIS = "))";
    private static final String SINGLE_OPEN_PARENTHESIS = "(";
    private static final String SINGLE_CLOSED_PARENTHESIS = ")";
    private final String memberName;
    private final String newMemberName;
    private final boolean isReplaceEnabled;

    public IncludeMember(String memberName, String newMemberName, boolean isReplaceEnabled) {
        this.memberName = memberName.trim();
        this.newMemberName = newMemberName.trim();
        this.isReplaceEnabled = isReplaceEnabled;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getArguments() {
        if (this.isReplaceEnabled) {
            return this.encloseInDoubleParenthesis(this.memberName + COMMA + this.newMemberName + COMMA + REPLACE_OPTION);
        }
        if (!this.newMemberName.isEmpty()) {
            return this.encloseInDoubleParenthesis(this.memberName + COMMA + this.newMemberName);
        }
        return this.encloseInSingleParenthesis(this.memberName);
    }

    private String encloseInDoubleParenthesis(String s) {
        return DOUBLE_OPEN_PARENTHESIS + s + DOUBLE_CLOSED_PARENTHESIS;
    }

    private String encloseInSingleParenthesis(String s) {
        return SINGLE_OPEN_PARENTHESIS + s + SINGLE_CLOSED_PARENTHESIS;
    }
}

