/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.replacetoken.helpers;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.urbancode.zos.dataset.util.DsInfo;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Calendar;

public class DatasetWriter {
    private boolean isDatasetRecordTruncated = false;
    private final String dataset;
    private final String replacedContent;

    private DatasetWriter(String dataset, String replacedContent) {
        this.dataset = dataset;
        this.replacedContent = replacedContent;
    }

    public static DatasetWriter write(String dataset, String replacedContent) throws Exception {
        DatasetWriter datasetWriter = new DatasetWriter(dataset, replacedContent);
        datasetWriter.writeToDataset();
        return datasetWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDataset() throws Exception {
        try (BufferedReader replacedDataReader = new BufferedReader(new StringReader(this.replacedContent));){
            ISPFStatistics ispfStatistics = this.getISPFStats(this.dataset);
            int lineNo = 1;
            try (RecordWriter recordWriter = null;){
                String line;
                recordWriter = RecordWriter.newWriter((String)this.dataset, (int)1);
                DsInfo dsInfo = new DsInfo(this.dataset);
                while ((line = replacedDataReader.readLine()) != null) {
                    String record = String.format("%-" + dsInfo.getAvailableRecordLength() + "s", line.replaceAll("\\s+$", ""));
                    byte[] recordBytes = record.getBytes(ZUtil.getDefaultPlatformEncoding());
                    if (recordBytes.length > dsInfo.getAvailableRecordLength()) {
                        this.isDatasetRecordTruncated = true;
                        System.out.println("Warning: line " + lineNo + " of " + this.dataset + " exceeds " + dsInfo.getAvailableRecordLength() + " bytes and will be truncated.");
                        System.out.println(" " + lineNo + " of " + this.dataset + ": " + line);
                        recordWriter.write(recordBytes, 0, dsInfo.getAvailableRecordLength());
                    } else {
                        recordWriter.write(recordBytes, 0, recordBytes.length);
                    }
                    ++lineNo;
                }
            }
            if (ispfStatistics != null) {
                this.updateISPFStats(ispfStatistics, --lineNo, 0);
            }
        }
    }

    public boolean isDatasetRecordTruncated() {
        return this.isDatasetRecordTruncated;
    }

    private ISPFStatistics getISPFStats(String name) throws Exception {
        if (!name.startsWith("//'") || !name.endsWith(")'")) {
            return null;
        }
        name = name.substring(3, name.length() - 1);
        String dataset = name.substring(0, name.indexOf("("));
        String member = name.substring(name.indexOf("(") + 1, name.length() - 1);
        return new ISPFStatistics(dataset, member);
    }

    private boolean updateISPFStats(ISPFStatistics stats, int currentLines, int modifiedLines) {
        if (stats == null) {
            return false;
        }
        try {
            Calendar cal = Calendar.getInstance();
            stats.setModificationDate(cal.getTime());
            stats.setModifiedLines(modifiedLines);
            stats.setCurrentLines(currentLines);
            stats.setUserId(ZUtil.getCurrentUser());
            stats.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

