/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.replacetoken.helpers;

import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class ReplaceTokensMVSInputs {
    public static final String INCLUDES = "includes";
    public static final String IS_WILD_CARD_ALLOWED = "isWildCardAllowed";
    public static final String FAIL_ON_TRUNCATE = "failOnTruncate";
    public static final String EXCLUDES = "excludes";
    public static final String START_DELIMITER = "startDelimiter";
    public static final String END_DELIMITER = "endDelimiter";
    public static final String PROPERTY_PREFIX = "propertyPrefix";
    public static final String ENV_PROP_VALUES = "envPropValues";
    public static final String EXPLICIT_TOKENS = "explicitTokens";
    private static final String WILDCARD_ASTERISK = "*";
    private final String includes;
    private final boolean isWildCardAllowed;
    private final boolean failOnTruncate;
    private final String excludes;
    private final String startDelimiter;
    private final String endDelimiter;
    private final String propertyPrefix;
    private final String envPropValues;
    private final String explicitTokens;

    private ReplaceTokensMVSInputs(Properties inputProperties) {
        this.includes = inputProperties.getProperty(INCLUDES).trim();
        this.isWildCardAllowed = Boolean.parseBoolean(inputProperties.getProperty(IS_WILD_CARD_ALLOWED).trim());
        this.failOnTruncate = Boolean.parseBoolean(inputProperties.getProperty(FAIL_ON_TRUNCATE).trim());
        this.excludes = inputProperties.getProperty(EXCLUDES).trim();
        this.startDelimiter = inputProperties.getProperty(START_DELIMITER).trim();
        this.endDelimiter = inputProperties.getProperty(END_DELIMITER).trim();
        this.propertyPrefix = inputProperties.getProperty(PROPERTY_PREFIX).trim();
        this.envPropValues = inputProperties.getProperty(ENV_PROP_VALUES).trim();
        this.explicitTokens = inputProperties.getProperty(EXPLICIT_TOKENS).trim();
    }

    public static ReplaceTokensMVSInputs getValidatedInputs(Properties inputProperties) {
        ReplaceTokensMVSInputs inputs = new ReplaceTokensMVSInputs(inputProperties);
        inputs.validate();
        return inputs;
    }

    private void validate() {
        InputsValidator.checkIfEmpty(this.includes, "Includes");
        if (this.includes.contains(WILDCARD_ASTERISK) && !this.isWildCardAllowed) {
            throw new InvalidInputException("Set Allow Wildcard to true to use wildcard(*) in Include Data Sets.");
        }
    }

    public String getIncludes() {
        return this.includes;
    }

    public boolean isWildCardAllowed() {
        return this.isWildCardAllowed;
    }

    public boolean isFailOnTruncate() {
        return this.failOnTruncate;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public String getEnvPropValues() {
        return this.envPropValues;
    }

    public String getExplicitTokens() {
        return this.explicitTokens;
    }
}

