/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.restore.backup;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.command.version.mappings.InvalidMappingException;
import com.urbancode.air.plugin.command.version.mappings.MappingHelper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class RestoreDatasetMapper {
    private final Map<String, String> srcTargetMapWithRegEx = new LinkedHashMap<String, String>();
    private final Map<String, String> srcTargetMapWithoutRegEx = new LinkedHashMap<String, String>();
    private final String datasetMapping;

    private RestoreDatasetMapper(String datasetMapping) {
        this.datasetMapping = datasetMapping;
    }

    public static RestoreDatasetMapper from(String datasetMapping) {
        RestoreDatasetMapper restoreDatasetMapper = new RestoreDatasetMapper(datasetMapping);
        restoreDatasetMapper.loadMappingIntoMaps();
        return restoreDatasetMapper;
    }

    private void loadMappingIntoMaps() {
        List<String> mappingPairs = StringHelper.getLines(this.datasetMapping);
        for (String mappingPair : mappingPairs) {
            if ((mappingPair = mappingPair.trim()).isEmpty()) continue;
            this.loadPairIntoMap(mappingPair);
        }
    }

    private void loadPairIntoMap(String mappingPair) {
        String[] onePair = mappingPair.split(",");
        if (onePair.length != 2) {
            throw new InvalidMappingException("Dataset Mapping is incorrect - " + mappingPair);
        }
        String source = onePair[0].trim();
        String target = onePair[1].trim();
        if (source.isEmpty()) {
            throw new InvalidMappingException("Missing source dataset in Dataset Mapping - " + mappingPair);
        }
        if (MappingHelper.containsWildcardCharacter(source)) {
            this.loadMappingIntoMapWithWildcard(source, target);
        } else {
            this.loadMappingIntoMapWithoutWildcard(source, target);
        }
    }

    private void loadMappingIntoMapWithoutWildcard(String source, String target) {
        if (this.srcTargetMapWithoutRegEx.containsKey(source)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.srcTargetMapWithoutRegEx.get(source));
        } else {
            this.srcTargetMapWithoutRegEx.put(source, target);
        }
    }

    private void loadMappingIntoMapWithWildcard(String source, String target) {
        String sourceWithRegularExp = MappingHelper.convertWildcardsToRegularExp(source);
        if (this.srcTargetMapWithRegEx.containsKey(sourceWithRegularExp)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.srcTargetMapWithRegEx.get(sourceWithRegularExp));
        } else {
            this.srcTargetMapWithRegEx.put(sourceWithRegularExp, target);
        }
    }

    public Map<String, String> getSrcTargetMapWithRegEx() {
        return this.srcTargetMapWithRegEx;
    }

    public Map<String, String> getSrcTargetMapWithoutRegEx() {
        return this.srcTargetMapWithoutRegEx;
    }
}

