/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DatasetsPropertiesXml {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String DATASETS_TAG = "datasets";
    private static final String DATASET_TAG = "dataset";
    private static final String DATASET_NAME_ATTRIBUTE = "name";
    private static final String LOAD = "LOAD";
    private static final String DBRM = "DBRM";
    private static final String OBJ = "OBJ";
    private static final String SYS_ID_LIBTYPE = "SYS.id.LIBTYPE";
    private static final String SYS_ID_RECORG = "SYS.id.RECORG";
    private static final String SYS_ID_RECLN = "SYS.id.RECLN";
    private static final String SYS_ID_BLKSZ = "SYS.id.BLKSZ";
    private static final String SYS_ID_RECFM = "SYS.id.RECFM";
    private static final String LIB_TYPE = "LIB_TYPE";
    private static final String REC_ORG = "REC_ORG";
    private static final String REC_LEN = "REC_LEN";
    private static final String BLOCK_SIZE = "BLOCK_SIZE";
    private static final String REC_FORMAT = "REC_FORMAT";
    private static final String CP_OPTION = "CP_OPTION";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private DatasetsPropertiesXml() {
    }

    public static String generate(String packageManifestPath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath);
        DatasetsPropertiesXml datasetsPropertiesXml = new DatasetsPropertiesXml();
        return datasetsPropertiesXml.generateXML(packageManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXML(PackageManifest packageManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(packageManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(PackageManifest packageManifest) throws XMLStreamException {
        this.createXmlHeaderTag();
        this.createStartingDatasetsTag();
        List<Container> datasetContainers = this.getDatasetContainers(packageManifest);
        this.writeDatasets(datasetContainers);
        this.writeEndingDatasetsTag();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void createStartingDatasetsTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(DATASETS_TAG);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private List<Container> getDatasetContainers(PackageManifest packageManifest) {
        return packageManifest.getAddedContainers().stream().filter(Container::isDataset).collect(Collectors.toList());
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDatasets(List<Container> datasetContainers) throws XMLStreamException {
        for (Container container : datasetContainers) {
            this.writeStartingDatasetTag(container.getSourceName());
            CopyType copyType = this.determineCopyType(container);
            this.writeProperty(CP_OPTION, copyType.getCpOption());
            this.validateDatasetProperties(container);
            this.writeDatasetProperties(container.getCustomerProperties());
            this.writeEndElement();
        }
    }

    private void writeEndingDatasetsTag() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingDatasetTag(String datasetName) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(DATASET_TAG);
        this.xmlStreamWriter.writeAttribute(DATASET_NAME_ATTRIBUTE, datasetName);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void validateDatasetProperties(Container container) {
        try {
            this.validateProperty(container.getCustomerProperties(), SYS_ID_LIBTYPE);
            this.validateProperty(container.getCustomerProperties(), SYS_ID_RECORG);
            this.validateProperty(container.getCustomerProperties(), SYS_ID_RECLN);
            this.validateProperty(container.getCustomerProperties(), SYS_ID_BLKSZ);
            this.validateProperty(container.getCustomerProperties(), SYS_ID_RECFM);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " for dataset container " + container.getSourceName());
        }
    }

    private void validateProperty(Map<String, String> propertyMap, String propertyName) {
        if (!propertyMap.containsKey(propertyName)) {
            throw new IllegalArgumentException("Property " + propertyName + " does not exist");
        }
        if (propertyMap.get(propertyName).trim().isEmpty()) {
            throw new IllegalArgumentException("Property " + propertyName + " is empty");
        }
    }

    private void writeDatasetProperties(Map<String, String> propertyMap) throws XMLStreamException {
        this.writeProperty(LIB_TYPE, propertyMap.get(SYS_ID_LIBTYPE));
        this.writeProperty(REC_ORG, propertyMap.get(SYS_ID_RECORG));
        this.writeProperty(REC_LEN, propertyMap.get(SYS_ID_RECLN));
        this.writeProperty(BLOCK_SIZE, propertyMap.get(SYS_ID_BLKSZ));
        this.writeProperty(REC_FORMAT, propertyMap.get(SYS_ID_RECFM));
    }

    private CopyType determineCopyType(Container container) {
        if (container.getCopyType() != null) {
            return container.getCopyType();
        }
        if (container.getDeployType() != null) {
            return this.determineCopyTypeFromDeployType(container.getDeployType());
        }
        throw new IllegalArgumentException("Attributes copyType (or) deployType not found for container " + container.getSourceName());
    }

    private CopyType determineCopyTypeFromDeployType(String deployType) {
        if ((deployType = deployType.toUpperCase()).contains(LOAD)) {
            return CopyType.EXEC;
        }
        if (deployType.contains(DBRM) || deployType.contains(OBJ)) {
            return CopyType.BINARY;
        }
        return CopyType.TEXT;
    }

    private void writeProperty(String propertyName, String propertyValue) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement("property");
        this.xmlStreamWriter.writeAttribute(DATASET_NAME_ATTRIBUTE, propertyName);
        this.xmlStreamWriter.writeAttribute("value", propertyValue);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

