/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata.crypto;

import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import com.urbancode.air.securedata.crypto.CryptoEngine;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.DefaultCryptoTable;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import java.security.SecureRandom;

public class DefaultCryptoEngine {
    private static CryptoEngine defaultEngine = new CryptoEngine(){

        public SecureRandom getRandom() {
            return new SecureRandom();
        }

        public MACAlgorithm getMACAlgorithm(String algorithm) {
            return DefaultCryptoTable.get().getMACAlgorithm(algorithm);
        }

        public CipherAlgorithm getCipherAlgorithm(String algorithm) {
            return DefaultCryptoTable.get().getCipherAlgorithm(algorithm);
        }

        public CryptoSuite getCryptoSuite(String suite) {
            return DefaultCryptoTable.get().getCryptoSuite(suite);
        }
    };

    public static synchronized CryptoEngine get() {
        return defaultEngine;
    }

    public static synchronized CryptoEngine set(CryptoEngine engine) {
        CryptoEngine old = defaultEngine;
        defaultEngine = engine;
        return old;
    }

    private DefaultCryptoEngine() {
    }
}

