/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.deploy.ElementsSorter;
import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import com.ibm.urbancode.zos.xml.utils.deploy.OrderBy;
import com.ibm.urbancode.zos.xml.utils.deploy.Reference;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Container
implements Comparable<Container> {
    private final List<String> targetContainers = new ArrayList<String>();
    private final Set<Resource> resources = new LinkedHashSet<Resource>();
    private final Map<String, String> customerProperties = new LinkedHashMap<String, String>();
    private final String sourceContainerName;
    private final ContainerType type;
    private Reference reference;
    private CopyType copyType;
    private String deployType;
    private Inputs inputs;
    private boolean isDeleted = false;

    Container(String sourceContainerName, ContainerType type) {
        this.sourceContainerName = sourceContainerName;
        this.type = type;
    }

    public Inputs getInputs() {
        return this.inputs;
    }

    void setInputs(Inputs inputs) {
        this.inputs = inputs;
    }

    void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public Set<Resource> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    void sortResources(OrderBy orderBy) {
        ArrayList<Resource> resources = new ArrayList<Resource>(this.resources);
        new ElementsSorter<Resource>(resources, orderBy).sort();
        this.resources.clear();
        this.resources.addAll(resources);
    }

    public List<String> getTargetContainers() {
        return this.targetContainers;
    }

    void setTargetContainers(List<String> targetContainers) {
        this.targetContainers.addAll(targetContainers);
    }

    public String getDeployType() {
        return this.deployType;
    }

    void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public Map<String, String> getCustomerProperties() {
        return Collections.unmodifiableMap(this.customerProperties);
    }

    void addCustomerProperty(String property, String value) {
        this.customerProperties.put(property, value);
    }

    public String getSourceContainerName() {
        return this.sourceContainerName;
    }

    public ContainerType getType() {
        return this.type;
    }

    public boolean isGeneric() {
        return this.type == ContainerType.GENERIC;
    }

    public boolean isDirectory() {
        return this.type == ContainerType.DIRECTORY;
    }

    public boolean isPds() {
        return this.type == ContainerType.PDS;
    }

    public boolean isSequential() {
        return this.type == ContainerType.SEQUENTIAL;
    }

    public boolean isDataset() {
        return this.isPds() || this.isSequential();
    }

    public CopyType getCopyType() {
        return this.copyType;
    }

    void setCopyType(CopyType copyType) {
        this.copyType = copyType;
    }

    void setDeleted() {
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public int compareTo(Container other) {
        return this.getSourceName().compareTo(other.getSourceName());
    }

    void removeResources(List<Resource> resourcesToBeRemoved) {
        resourcesToBeRemoved.forEach(this.resources::remove);
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String getSourceName() {
        if (this.sourceContainerName != null) {
            return this.sourceContainerName;
        }
        if (this.deployType != null) {
            return this.deployType;
        }
        throw new IllegalStateException("Container has neither sourceContainerName nor deployType defined.");
    }
}

