/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.NaturalComparator;
import java.util.Comparator;
import java.util.Locale;

public enum Case {
    SENSITIVE{

        @Override
        public Comparator<String> comparator() {
            return new NaturalComparator<String>();
        }
    }
    ,
    INSENSITIVE{

        @Override
        public Comparator<String> comparator() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    };


    public static Case getSystemCaseSensitivity() {
        String os = System.getProperty("os.name").toLowerCase(Locale.US);
        return os.indexOf("windows") == -1 && os.indexOf("vms") == -1 ? SENSITIVE : INSENSITIVE;
    }

    public abstract Comparator<String> comparator();
}

