/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.immutable.IImmutableCollection;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullCollections;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

final class NonNullImmutableCollection<T>
implements IImmutableCollection<T>,
Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final IImmutableCollection<T> delegate;

    NonNullImmutableCollection(IImmutableCollection<T> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public IImmutableCollection<T> with(T element) {
        Check.nonNull(element, "element");
        IImmutableCollection<T> modified = this.delegate.with(element);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableCollection(modified);
        }
        return this;
    }
}

