/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import java.io.File;

public class DeploymentHelper {
    public static void validateFileExist(String filePath, String errorInfo) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(errorInfo);
        }
    }

    public static String getStringInput(String input) {
        if (input != null) {
            input = input.trim();
        }
        return input;
    }

    public static boolean getBooleanInput(String input) {
        if (input != null) {
            input = input.trim();
        }
        return Boolean.valueOf(input);
    }

    public static void inputNotEmptyCheck(String input, String errorInformation) {
        if (null == input || input.length() <= 0) {
            throw new IllegalArgumentException(errorInformation);
        }
    }

    public static String getVersionDirPathInWorkingDir(String basePath, String versionname, String resourceId) {
        return basePath + File.separator + resourceId + File.separator + versionname;
    }

    public static String getFilePathInWorkingDir(String basePath, String versionname, String resourceId, String fileName) {
        return DeploymentHelper.getVersionDirPathInWorkingDir(basePath, versionname, resourceId) + File.separator + fileName;
    }

    public static String getVersionDirPathInRepository(String basePath, String componentName, String versionName) {
        return basePath + File.separator + componentName + File.separator + versionName;
    }

    public static String getFilePathInRepository(String basePath, String componentName, String versionName, String fileName) {
        return DeploymentHelper.getVersionDirPathInRepository(basePath, componentName, versionName) + File.separator + fileName;
    }

    public static void cleanWorkDir(String workdir) {
        File versionWorkingDirectory = new File(workdir);
        if (versionWorkingDirectory.exists() && versionWorkingDirectory.isDirectory()) {
            versionWorkingDirectory.delete();
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

