/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.dataset.util.DeploymentHelper;
import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;

public class CopyArtifacts {
    private Properties inputProperties;
    private Properties outputProperties;

    public CopyArtifacts(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        boolean ERR_CODE = true;
        try {
            String workDir;
            String versionName = this.inputProperties.getProperty("versionName").trim();
            String repositoryType = this.inputProperties.getProperty("repositoryType").trim();
            String componentName = this.inputProperties.getProperty("componentName").trim();
            String repositoryPath = this.inputProperties.getProperty("basePath").trim();
            String directoryOffset = this.inputProperties.getProperty("directoryOffset").trim();
            String resourceId = this.inputProperties.getProperty("resourceId").trim();
            if (!repositoryType.equals("HFS")) {
                System.out.println("Version " + versionName + " is stored in " + repositoryType + " instead of HFS.");
                System.out.println("Copy failed.");
                return 1;
            }
            System.out.println("\nUPDATE:");
            System.out.println("All customers should note that with 7.1.0.2 release, we are officially announcing end of support for HFS codestation as an Artifact Repository on May, 2021. ");
            System.out.println("All users are strongly encouraged to migrate to either in-built artifact repository Codestation or ");
            System.out.println("supported third party artifact repositories ArtifactoryTM or NexusTM (supported from version 7.0.5).");
            System.out.println();
            String workingComponentPath = workDir = new File(".").getCanonicalPath();
            if (!DeploymentHelper.isNullOrEmpty(directoryOffset)) {
                workingComponentPath = new File(workDir, directoryOffset).getCanonicalPath();
            }
            String pkgZipFilePathInRepo = DeploymentHelper.getFilePathInRepository(repositoryPath, componentName, versionName, "package.zip");
            String pkgZipFilePathToWorkingDir = DeploymentHelper.getFilePathInWorkingDir(workingComponentPath, versionName, resourceId, "package.zip");
            String pkgManifestFilePathInRepo = DeploymentHelper.getFilePathInRepository(repositoryPath, componentName, versionName, "packageManifest.xml");
            String pkgManifestPathToWorkingdir = DeploymentHelper.getFilePathInWorkingDir(workingComponentPath, versionName, resourceId, "packageManifest.xml");
            DeploymentHelper.validateFileExist(pkgManifestFilePathInRepo, pkgManifestFilePathInRepo + " does not exist in the repository");
            String workVersionDir = DeploymentHelper.getVersionDirPathInWorkingDir(workingComponentPath, versionName, resourceId);
            DeploymentHelper.cleanWorkDir(workVersionDir);
            System.out.println("Start to copy files");
            this.copyFile(new File(pkgManifestFilePathInRepo), new File(pkgManifestPathToWorkingdir));
            DeploymentHelper.validateFileExist(pkgManifestPathToWorkingdir, "Error copying packageManifest.xml to " + pkgManifestPathToWorkingdir);
            File packageZipfile = new File(pkgZipFilePathInRepo);
            if (packageZipfile.exists() && packageZipfile.isFile()) {
                this.copyFile(new File(pkgZipFilePathInRepo), new File(pkgZipFilePathToWorkingDir));
            } else {
                System.out.println(" [Warning] " + pkgZipFilePathInRepo + " doesn't exist. Version does not have physical artifacts.");
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private void copyFile(File src, File dst) throws BuildException {
        Copy cp = new Copy();
        cp.setTofile(dst);
        cp.setFile(src);
        cp.setOverwrite(true);
        cp.setVerbose(true);
        cp.execute();
    }
}

