/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;

public class AllocateLike {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("datasetName").trim();
            String inlikeDatasetName = inputProperties.getProperty("likeDatasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(inputProperties.getProperty("deleteDataset"));
            String volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = inputProperties.getProperty("spaceUnit").trim();
            int primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            if (DeploymentHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                System.exit(1);
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    System.exit(1);
                }
            }
            if (DeploymentHelper.isNullOrEmpty(inlikeDatasetName)) {
                System.out.println(" [Error] Like data set name can not be empty.");
                System.exit(1);
            }
            String likeDatasetName = "";
            likeDatasetName = inlikeDatasetName.startsWith("'") ? inlikeDatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)inlikeDatasetName);
            String zFileLikeDsn = ZFile.getSlashSlashQuotedDSN((String)likeDatasetName, (boolean)true);
            if (!ZFile.dsExists((String)zFileLikeDsn)) {
                System.out.println(" [ERROR] Like Dataset " + likeDatasetName + " does not exist");
                System.exit(1);
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") like(" + likeDatasetName + ")";
            if (primaryQuantity > 0 && secondaryQuantity > 0) {
                allocCommand = allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
                if (spaceUnit.equals("TRACKS") || spaceUnit.equals("CYL")) {
                    allocCommand = allocCommand + " " + spaceUnit;
                }
            }
            if (!DeploymentHelper.isNullOrEmpty(volumeSerial)) {
                allocCommand = allocCommand + " vol(" + volumeSerial + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Comand: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                String fileDDname = "//DD:" + ddName;
                try {
                    ZFile zFile = new ZFile(fileDDname, "r");
                    datasetName = zFile.getActualFilename();
                    zFile.close();
                }
                catch (Exception e) {
                    ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
                    e.printStackTrace();
                    System.exit(1);
                }
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                apTool.setOutputProperty("DatasetName", datasetName);
                apTool.storeOutputProperties();
                System.exit(0);
            } else {
                System.out.println(" [Error] Failed to create dataset " + datasetName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

