/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class CopyDataset {
    private Properties inputProperties;
    private Properties outputProperties;

    public CopyDataset(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        int ERR_CODE = 8;
        int LRECL = 80;
        String LINE_SEPERATOR = System.getProperty("line.separator");
        BufferedWriter scriptWriter = null;
        BufferedWriter sysinWriter = null;
        try {
            String st;
            String line;
            int i;
            String fromPDS = this.inputProperties.getProperty("sourcePDS").toUpperCase().trim();
            String toPDS = this.inputProperties.getProperty("toPDS").toUpperCase().trim().replace("'", "");
            String includeMembers = this.inputProperties.getProperty("includeMembers").trim().toUpperCase();
            String excludeMembers = this.inputProperties.getProperty("excludeMembers").trim().toUpperCase();
            boolean isLoadModule = Boolean.valueOf(this.inputProperties.getProperty("isLoadModule"));
            if (DeploymentHelper.isNullOrEmpty(fromPDS)) {
                System.out.println(" [Error] Input 'From PDS' is either empty or null.");
                return 8;
            }
            if (DeploymentHelper.isNullOrEmpty(toPDS)) {
                System.out.println(" [Error] Input 'To PDS' is either empty or null.");
                return 8;
            }
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)toPDS, (boolean)true);
            if (!ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [Error] 'To PDS' dataset " + toPDS + " does not exist.");
                return 8;
            }
            if (!DeploymentHelper.isNullOrEmpty(includeMembers) && !DeploymentHelper.isNullOrEmpty(excludeMembers)) {
                System.out.println(" [Error] Inputs 'Include Members' and 'Exclude Members' are mutually exclusive.");
                return 8;
            }
            if (includeMembers.contains("*") || includeMembers.contains("%")) {
                System.out.println(" [Error] Wildcards are not supported in member name. Input 'Include Members' contains wildcard '*' or '%'.");
                return 8;
            }
            if (excludeMembers.contains("*") || excludeMembers.contains("%")) {
                System.out.println(" [Error] Wildcards are not supported in member name. Input 'Exclude Members' contains wildcard '*' or '%'.");
                return 8;
            }
            File sysinFile = File.createTempFile("COPY", ".SYSIN");
            sysinFile.deleteOnExit();
            sysinWriter = new BufferedWriter(new FileWriter(sysinFile.getAbsolutePath()));
            HashSet<String> inputDsnSet = new HashSet<String>();
            if (isLoadModule) {
                sysinWriter.append(StringUtils.rightPad((String)"COPERST1 COPYMOD OUTDD=SYSUT2", (int)80));
            } else {
                sysinWriter.append(StringUtils.rightPad((String)"COPERST1 COPY OUTDD=SYSUT2", (int)80));
            }
            String[] fromPDSlines = fromPDS.split(LINE_SEPERATOR);
            for (int i2 = 0; i2 < fromPDSlines.length; ++i2) {
                fromPDSlines[i2].trim();
                String[] fromPDSLine = fromPDSlines[i2].split(",");
                if (fromPDSLine.length == 2 && fromPDSLine[1].trim().equals("R")) {
                    sysinWriter.append(StringUtils.rightPad((String)("              INDD=((INDD" + i2 + ",R))"), (int)80));
                } else if (fromPDSLine.length == 1) {
                    sysinWriter.append(StringUtils.rightPad((String)("              INDD=(INDD" + i2 + ")"), (int)80));
                } else {
                    System.out.println(" [Error] Incorrect format at line no. " + (i2 + 1) + " in 'From PDS'. It must be either \"PDS-NAME (or) PDS-NAME,R\" .");
                    sysinWriter.close();
                    return 8;
                }
                String inputDsn = fromPDSLine[0].trim().replace("'", "");
                if (DeploymentHelper.isNullOrEmpty(inputDsn)) {
                    System.out.println(" [Error] Input 'From PDS' dataset at line no. " + (i2 + 1) + " is either empty or null.");
                    sysinWriter.close();
                    return 8;
                }
                if (!inputDsnSet.contains(inputDsn)) {
                    if (inputDsn.equals(toPDS)) {
                        System.out.println(" [Error] Inputs 'From PDS' and 'To PDS' have same dataset " + inputDsn);
                        sysinWriter.close();
                        return 8;
                    }
                    String zInputDsn = ZFile.getSlashSlashQuotedDSN((String)inputDsn, (boolean)true);
                    if (!ZFile.dsExists((String)zInputDsn)) {
                        System.out.println(" [Error] Dataset " + inputDsn + " at line no. " + (i2 + 1) + " in 'From PDS' input does not exist.");
                        sysinWriter.close();
                        return 8;
                    }
                } else {
                    System.out.println(" [Error] Duplicate entry found for dataset " + inputDsn + " in 'From PDS' input.");
                    sysinWriter.close();
                    return 8;
                }
                fromPDSlines[i2] = inputDsn;
                inputDsnSet.add(inputDsn);
            }
            File sysprintFile = File.createTempFile("COPY", ".SYSPRINT");
            File scriptFile = File.createTempFile("COPY", ".rexx");
            scriptWriter = new BufferedWriter(new FileWriter(scriptFile.getCanonicalPath()));
            scriptWriter.append("/* rexx */\n");
            scriptWriter.append("userid = USERID()\n");
            scriptWriter.append("ADDRESS TSO\n");
            scriptWriter.append("\"ALLOC PATH('" + sysinFile.getCanonicalPath() + "') DDNAME(SYSIN) PATHDISP(keep,keep) PATHOPTS(ORDONLY) PATHMODE(SIRUSR) \"\n");
            scriptWriter.append("if rc <> 0 then do\n");
            scriptWriter.append("    say 'Error allocating SYSIN for IEBCOPY '\n");
            scriptWriter.append("    return 8\n");
            scriptWriter.append("end\n");
            for (i = 0; i < fromPDSlines.length; ++i) {
                String inDsnName = fromPDSlines[i];
                inDsnName = "'" + inDsnName + "'";
                scriptWriter.append("\"ALLOC DATASET(" + inDsnName + ") DDNAME(INDD" + i + ") SHR  REUSE\"\n");
                scriptWriter.append("say \"Allocation for data set " + inDsnName + " ends with \"rc\n");
                scriptWriter.append("if rc <> 0 then return 8\n");
            }
            scriptWriter.append("\"ALLOC DATASET('" + toPDS + "') DDNAME(SYSUT2) SHR  REUSE\"\n");
            scriptWriter.append("if rc <> 0 then do\n");
            scriptWriter.append("    say 'Error allocating DD for To PDS'\n");
            scriptWriter.append("    return 8\n");
            scriptWriter.append("end\n");
            scriptWriter.append("\"ALLOC PATH('" + sysprintFile.getCanonicalPath() + "') DDNAME(SYSPRINT) FILEDATA(TEXT) pathdisp(keep,keep) pathopts(owronly,ocreat) PATHMODE(SIRUSR)\"\n");
            scriptWriter.append("ADDRESS TSO 'LISTALC STATUS'\n");
            scriptWriter.append("ADDRESS TSO 'IEBCOPY'\n");
            scriptWriter.append("exitRC =rc\n");
            scriptWriter.append("if rc <> 0 then say 'Error executing IEBCOPY'\n");
            for (i = 0; i < inputDsnSet.size(); ++i) {
                scriptWriter.append("\"FREE DDNAME(INDD" + i + ")\"\n");
            }
            scriptWriter.append("\"FREE DDNAME(SYSUT2) \"\n");
            scriptWriter.append("if rc <> 0 then say 'Error free To PDS'\n");
            scriptWriter.append("\"FREE DDNAME(SYSPRINT) \"\n");
            scriptWriter.append("\"FREE DDNAME(SYSIN) \"\n");
            scriptWriter.append("return exitRC\n");
            if (!DeploymentHelper.isNullOrEmpty(includeMembers)) {
                String[] includeMemberLines = includeMembers.split(LINE_SEPERATOR);
                for (int i3 = 0; i3 < includeMemberLines.length; ++i3) {
                    String includeMemberLine = includeMemberLines[i3].trim();
                    if (includeMemberLine.startsWith(",") || includeMemberLine.endsWith(",")) {
                        System.out.println(" [Error] Input 'Include Members' at line no. " + (i3 + 1) + " has incorrect data.");
                        sysinWriter.close();
                        scriptWriter.close();
                        return 8;
                    }
                    String[] includeMemberLineParms = includeMemberLine.split(",");
                    if (includeMemberLineParms.length > 1) {
                        String replaceOption;
                        if (includeMemberLineParms.length == 3 && !(replaceOption = includeMemberLineParms[2]).equals("R")) {
                            System.out.println(" [Error] Member in input 'Include Members' at line no. " + (i3 + 1) + " has incorrect replace parameter.");
                            sysinWriter.close();
                            scriptWriter.close();
                            return 8;
                        }
                        if (includeMemberLineParms.length != 2 && includeMemberLineParms.length > 3) {
                            System.out.println(" [Error] Member in input 'Include Members' has incorrect format at line no. " + (i3 + 1) + ". It must be either \"MEMBER-NAME (or) MEMBER-NAME, NEW-MEMBER-NAME[, R] (or) MEMBER-NAME,,R\" .");
                            sysinWriter.close();
                            scriptWriter.close();
                            return 8;
                        }
                        sysinWriter.append(StringUtils.rightPad((String)("         SELECT MEMBER=((" + includeMemberLine + "))"), (int)80));
                        continue;
                    }
                    if (DeploymentHelper.isNullOrEmpty(includeMemberLine)) {
                        System.out.println(" [Error] Member in input 'Include Members' at line no. " + (i3 + 1) + " is either empty or null.");
                        sysinWriter.close();
                        scriptWriter.close();
                        return 8;
                    }
                    sysinWriter.append(StringUtils.rightPad((String)("         SELECT MEMBER=" + includeMemberLine), (int)80));
                }
            } else if (!DeploymentHelper.isNullOrEmpty(excludeMembers)) {
                String[] excludeMemberLines = excludeMembers.split(LINE_SEPERATOR);
                for (int i4 = 0; i4 < excludeMemberLines.length; ++i4) {
                    String excludeMemberLine = excludeMemberLines[i4].trim();
                    if (DeploymentHelper.isNullOrEmpty(excludeMemberLine)) {
                        System.out.println(" [Error] Member in input 'Exclude Members' at line no. " + (i4 + 1) + " is either empty or null.");
                        sysinWriter.close();
                        scriptWriter.close();
                        return 8;
                    }
                    sysinWriter.append(StringUtils.rightPad((String)("        EXCLUDE MEMBER=" + excludeMemberLine), (int)80));
                }
            }
            scriptWriter.close();
            sysinWriter.close();
            scriptFile.setExecutable(true);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(scriptFile.getCanonicalPath());
            Process process = processBuilder.start();
            StringBuilder output = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            output.append("out:\n");
            while ((line = reader.readLine()) != null) {
                output.append(line + "\n");
            }
            int exitVal = process.waitFor();
            System.out.println(" [SYSPRINT OUTPUT] ");
            BufferedReader br = new BufferedReader(new FileReader(sysprintFile));
            while ((st = br.readLine()) != null) {
                System.out.println(st);
            }
            br.close();
            scriptFile.deleteOnExit();
            sysinFile.deleteOnExit();
            sysprintFile.deleteOnExit();
            if (exitVal != 0) {
                System.out.println(output);
                System.out.println("Program terminated with return code " + exitVal);
                return 8;
            }
            System.out.println("Copy data set completed.");
            System.out.println(output.toString());
            System.out.println("The rexx script is executed successfully.");
            return 0;
        }
        catch (Exception e) {
            if (scriptWriter != null) {
                try {
                    scriptWriter.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return 8;
                }
            }
            if (sysinWriter != null) {
                try {
                    sysinWriter.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return 8;
                }
            }
            e.printStackTrace();
            return 8;
        }
    }
}

