/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;

public class DeleteDataset {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("datasetName").trim();
            String membersList = inputProperties.getProperty("membersList").trim();
            if (DeploymentHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Dataset Name can not be empty.");
                System.exit(1);
            }
            if (indatasetName.contains("*") || indatasetName.contains("%")) {
                System.out.println(" [Error] Wildcards (*) or (%) are not allowed in the dataset name to be deleted.");
                System.exit(1);
            }
            if (membersList.contains("*") || membersList.contains("%")) {
                System.out.println(" [Error] Wildcards (*) or (%) are not allowed in the member name to be deleted.");
                System.exit(1);
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (!ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [Warning] Dataset " + datasetName + " does not exist.");
                System.exit(0);
            }
            if (datasetName.contains("(")) {
                String ddName = ZFile.allocDummyDDName();
                String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") reuse shr msg(wtp)";
                ZFile.bpxwdyn((String)allocCommand);
                datasetName = DeploymentHelper.getGDGActualName(ddName);
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            if (DeploymentHelper.isNullOrEmpty(membersList)) {
                ZFile.remove((String)zFileDsn);
                System.out.println(" [Info] Deleted " + datasetName);
            } else {
                System.out.println("....Deleting members in PDS " + datasetName);
                BufferedReader reader = new BufferedReader(new StringReader(membersList));
                String member = reader.readLine();
                while (member != null) {
                    if (!member.isEmpty()) {
                        member = member.trim();
                        String dsMember = datasetName + "(" + member + ")";
                        zFileDsn = ZFile.getSlashSlashQuotedDSN((String)dsMember, (boolean)true);
                        if (!ZFile.dsExists((String)zFileDsn)) {
                            System.out.println(" [Warning] Skipped deleting " + member + " as member does not exist.");
                        } else {
                            ZFile.remove((String)zFileDsn);
                            System.out.println(" [Info] Deleted " + member);
                        }
                    }
                    member = reader.readLine();
                }
            }
            apTool.setOutputProperty("DeletedDatasetName", datasetName);
            apTool.storeOutputProperties();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

