/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Locale;
import java.util.Properties;

public class WaitForJob {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String jobId = inputProperties.getProperty("jobId").trim();
            String timeout = inputProperties.getProperty("timeout").trim();
            String showOutput = inputProperties.getProperty("showOutput").trim();
            String cutOff = inputProperties.getProperty("cutOff").trim();
            String maxRC = inputProperties.getProperty("maxRC").trim();
            String hostname = inputProperties.getProperty("hostname").trim();
            String userid = inputProperties.getProperty("userid").trim();
            String password = inputProperties.getProperty("password").trim();
            String port = inputProperties.getProperty("port").trim();
            boolean usePassticket = Boolean.valueOf(inputProperties.getProperty("usePassticket").trim());
            String irrracfLibraryPath = inputProperties.getProperty("irrracfLibraryPath").trim();
            String inUseRunId = inputProperties.getProperty("useRunId").trim().toUpperCase();
            boolean useRunId = false;
            String APPL_ID = "FEKAPPL";
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            if (DeploymentHelper.isNullOrEmpty(jobId)) {
                System.out.println(" [ERROR] Job ID cannot be empty.");
                System.exit(1);
            }
            if (DeploymentHelper.isNullOrEmpty(hostname)) {
                System.out.println(" [ERROR] Host Name cannot be empty.");
                System.exit(1);
            }
            if (DeploymentHelper.isNullOrEmpty(port)) {
                System.out.println(" [ERROR] Port cannot be empty.");
                System.exit(1);
            }
            if (inUseRunId.equals("TRUE")) {
                if (!osName.equalsIgnoreCase("z/OS")) {
                    System.out.println(" [ERROR] Using Agent/Impersonation Id to run wait For Job step is not available for a non-zOS agent.");
                    System.exit(1);
                }
                useRunId = true;
            } else {
                if (DeploymentHelper.isNullOrEmpty(userid)) {
                    System.out.println(" [ERROR] User ID cannot be empty.");
                    System.exit(1);
                }
                userid = userid.toUpperCase();
                if (DeploymentHelper.isNullOrEmpty(password)) {
                    if (!osName.equalsIgnoreCase("z/OS")) {
                        System.out.println(" [ERROR] Password is mandatory for non-zOS agent.");
                        System.exit(1);
                    } else if (usePassticket) {
                        System.out.println("Password is empty. Using PassTicket authentication.");
                        password = PassTicketUtil.generatePassTicket((String)userid, (String)"FEKAPPL", (String)irrracfLibraryPath);
                    } else {
                        System.out.println(" [ERROR] Password cannot be empty.");
                        System.exit(1);
                    }
                }
            }
            JobUtil jobUtil = new JobUtil(hostname, port, userid, password, useRunId);
            try {
                int timeoutValue = Integer.valueOf(timeout);
                jobUtil.setTimeout(timeoutValue);
            }
            catch (NumberFormatException e) {
                System.out.println(" [ERROR] Time Out isn't a number.");
                System.exit(1);
            }
            try {
                int cutOffValue = Integer.valueOf(cutOff);
                if (cutOffValue < 0) {
                    cutOffValue = 0x7FFFFFF8;
                }
                jobUtil.setCutoff(cutOffValue);
            }
            catch (NumberFormatException e) {
                System.out.println(" [ERROR] Cut Off isn't a number.");
                System.exit(1);
            }
            try {
                int maxRCValue = Integer.valueOf(maxRC);
                jobUtil.setMaxReturnCode(maxRCValue);
            }
            catch (NumberFormatException e) {
                System.out.println(" [ERROR] Max Return Code isn't a number.");
                System.exit(1);
            }
            jobUtil.setShowOutput(showOutput);
            boolean success = jobUtil.waitForJob(jobId);
            jobUtil.printLog(jobId);
            JESJob job = jobUtil.getJob(jobId, true);
            apTool.setOutputProperty("JobId", jobId);
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            apTool.storeOutputProperties();
            jobUtil.disconnect();
            if (success) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

