/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;

public class AllocateDatasetSms {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("datasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(inputProperties.getProperty("deleteDataset"));
            String managementClass = inputProperties.getProperty("managementClass").trim();
            String storageClass = inputProperties.getProperty("storageClass").trim();
            String dataClass = inputProperties.getProperty("dataClass");
            if (DeploymentHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                System.exit(1);
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    System.exit(1);
                }
            }
            if (DeploymentHelper.isNullOrEmpty(managementClass) && DeploymentHelper.isNullOrEmpty(storageClass) && DeploymentHelper.isNullOrEmpty(dataClass)) {
                System.out.println(" [Error] At least one class needs to be specified.");
                System.exit(1);
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!DeploymentHelper.isNullOrEmpty(managementClass)) {
                allocCommand = allocCommand + " MGMTCLAS(" + managementClass + ")";
            }
            if (!DeploymentHelper.isNullOrEmpty(storageClass)) {
                allocCommand = allocCommand + " STORCLAS(" + storageClass + ")";
            }
            if (!DeploymentHelper.isNullOrEmpty(dataClass)) {
                allocCommand = allocCommand + " DATACLAS(" + dataClass + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Comand: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                datasetName = DeploymentHelper.getGDGActualName(ddName);
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                apTool.setOutputProperty("DatasetName", datasetName);
                apTool.storeOutputProperties();
                System.exit(0);
            } else {
                System.out.println(" [Error] Failed to create dataset " + datasetName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

