/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class MvsCommand {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            MVSHelper mvsHelper;
            File sdsfJar;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String mvsCommand = inputProperties.getProperty("mvsCommand").trim();
            boolean stopOnFail = Boolean.valueOf(inputProperties.getProperty("stopOnFail").trim());
            String failMessage = inputProperties.getProperty("failMessage").trim();
            String sdsfJarFile = inputProperties.getProperty("sdsfJarFile").trim();
            String sdsfLibraryPath = inputProperties.getProperty("sdsfLibraryPath").trim();
            if (DeploymentHelper.isNullOrEmpty(sdsfJarFile)) {
                System.out.println(" [ERROR] SDSF Jar File cannot be empty.");
                System.exit(1);
            }
            if (!(sdsfJar = new File(sdsfJarFile)).exists() || !sdsfJar.canRead()) {
                System.out.println("Error reading SDSF Jar File: " + sdsfJarFile);
                System.exit(1);
            }
            if (DeploymentHelper.isNullOrEmpty(sdsfLibraryPath)) {
                System.out.println(" [ERROR] SDSF Native Library Path cannot be empty.");
                System.exit(1);
            }
            if (DeploymentHelper.isNullOrEmpty(mvsCommand)) {
                System.out.println(" [ERROR] MVS Commands cannot be empty.");
                System.exit(1);
            }
            if (!(mvsHelper = new MVSHelper(sdsfLibraryPath)).verifySDSF()) {
                System.exit(1);
            }
            ArrayList<String> failMessagesList = new ArrayList<String>();
            if (failMessage != null) {
                BufferedReader reader = new BufferedReader(new StringReader(failMessage));
                String line = reader.readLine();
                while (line != null) {
                    failMessagesList.add(line);
                    line = reader.readLine();
                }
            }
            boolean success = true;
            BufferedReader reader = new BufferedReader(new StringReader(mvsCommand));
            String line = reader.readLine();
            while (line != null) {
                if (!success && stopOnFail) {
                    System.out.println(line);
                } else if (!DeploymentHelper.isNullOrEmpty(line)) {
                    mvsHelper.runCommand(line);
                    boolean containsFailMessage = false;
                    if (mvsHelper.getReturnCode() == 0) {
                        System.out.println("===============================");
                        List resultsList = mvsHelper.getResults().getResponseList();
                        for (int i = 0; i < resultsList.size(); ++i) {
                            String message = (String)resultsList.get(i);
                            for (int j = 0; j < failMessagesList.size(); ++j) {
                                String failMsg = (String)failMessagesList.get(j);
                                if (!message.contains(failMsg)) continue;
                                containsFailMessage = true;
                                System.out.println("Following line in command response contains fail message : " + failMsg);
                                System.out.println(message);
                                System.out.println();
                            }
                        }
                        if (containsFailMessage) {
                            System.out.println("Step failed.");
                            System.out.println();
                        }
                    }
                    if (mvsHelper.getReturnCode() > 0 || containsFailMessage) {
                        success = false;
                        line = reader.readLine();
                        if (!stopOnFail || line == null) continue;
                        System.out.println("Following commands are not executed because Stop On Fail is set to true.");
                        continue;
                    }
                }
                line = reader.readLine();
            }
            if (!success) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Error executing MVS command: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

