/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.ibm.urbancode.zos.common.util.Interceptor;
import com.ibm.urbancode.zos.dataset.util.DataSetReader;
import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SubmitJob {
    private static AirPluginTool apTool;
    private static String encoding;
    private static final int ERR_CODE = 1;
    private static final String APP_ID = "FEKAPPL";
    private static final String PLUGIN_INPUT_PROPS = "PLUGIN_INPUT_PROPS";
    private static final String STDOUT_TXT = "stdOut.txt";
    private static byte byte4WhiteSpace;
    private static boolean contentExceedMaxNum;
    private static final int JCL_CODE_LENGTH = 71;
    private static final int JCL_LENGTH_WITH_LINE_NUMBERS = 80;
    private static final int JCL_LENGTH_WITHOUT_LINE_NUMBERS = 72;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        try {
            boolean isZos;
            apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            String mvsFilename = inputProperties.getProperty("mvsFilename").trim().toUpperCase();
            String ussFilename = inputProperties.getProperty("ussFilename").trim();
            String jclString = inputProperties.getProperty("jclString").trim();
            String jobCard = inputProperties.getProperty("jobCard").trim();
            String explicitTokens = inputProperties.getProperty("explicitTokens").trim();
            String explicitTokensForeachJob = inputProperties.getProperty("explicitTokensForeachJob").trim();
            boolean waitForJob = Boolean.parseBoolean(inputProperties.getProperty("waitForJob").trim());
            boolean stopOnFail = Boolean.parseBoolean(inputProperties.getProperty("stopOnFail").trim());
            String timeout = inputProperties.getProperty("timeout").trim();
            String showOutput = inputProperties.getProperty("showOutput").trim();
            String maxLines = inputProperties.getProperty("cutOff").trim();
            String maxRC = inputProperties.getProperty("maxRC").trim();
            String hostname = inputProperties.getProperty("hostname").trim();
            String userid = inputProperties.getProperty("userid").trim().toUpperCase();
            String password = inputProperties.getProperty("password").trim();
            String port = inputProperties.getProperty("port").trim();
            String inUseRunId = inputProperties.getProperty("useRunId").trim().toUpperCase();
            boolean outputPagination = Boolean.parseBoolean(inputProperties.getProperty("outputPagination").trim());
            boolean usePassticket = Boolean.parseBoolean(inputProperties.getProperty("usePassticket").trim());
            String irrracfLibraryPath = inputProperties.getProperty("irrracfLibraryPath").trim();
            if (osName.equalsIgnoreCase("z/OS")) {
                encoding = ZUtil.getDefaultPlatformEncoding();
                isZos = true;
            } else {
                encoding = System.getProperty("console.encoding", System.getProperty("file.encoding", "UTF-8"));
                isZos = false;
            }
            String whiteSpaceStr = new String(" ".getBytes(), encoding);
            byte[] whitespaceBytes = whiteSpaceStr.getBytes(encoding);
            byte4WhiteSpace = whitespaceBytes[0];
            if (DeploymentHelper.isNullOrEmpty(hostname)) {
                throw new IllegalArgumentException("Host Name can not be empty.");
            }
            if (DeploymentHelper.isNullOrEmpty(port)) {
                throw new IllegalArgumentException("Port can not be empty.");
            }
            boolean useRunId = false;
            if (inUseRunId.equals("TRUE")) {
                if (!isZos) {
                    throw new IllegalArgumentException("Using Agent/Impersonation Id to submit Job is not available for a non-zOS agent.");
                }
                useRunId = true;
                usePassticket = false;
            } else {
                if (DeploymentHelper.isNullOrEmpty(userid)) {
                    throw new IllegalArgumentException("User ID can not be empty.");
                }
                if (DeploymentHelper.isNullOrEmpty(password)) {
                    if (!isZos) {
                        throw new IllegalArgumentException("Password is mandatory for non-zOS agent.");
                    }
                    if (!usePassticket) throw new IllegalArgumentException("Password can not be empty.");
                    System.out.println("Password is empty. Using PassTicket authentication.");
                } else {
                    usePassticket = false;
                }
            }
            if (!isZos && !DeploymentHelper.isNullOrEmpty(mvsFilename)) {
                if (!DeploymentHelper.isNullOrEmpty(explicitTokensForeachJob) || !DeploymentHelper.isNullOrEmpty(explicitTokens)) {
                    throw new IllegalArgumentException("Token replacements can't be done from non zOS agents for MVS files");
                }
                if (mvsFilename.contains("*")) {
                    throw new IllegalArgumentException("PDS member patterns can't be used from  non zOS agents for MVS files");
                }
                if (!mvsFilename.contains("(")) {
                    throw new IllegalArgumentException("PDS without member names can't be used from non zOS agents for MVS files");
                }
            }
            JobUtil jobUtil = new JobUtil(hostname, port, userid, password, useRunId);
            TreeMap<String, String> jcls = new TreeMap<String, String>();
            if (!DeploymentHelper.isNullOrEmpty(mvsFilename)) {
                if (!isZos) {
                    jobUtil.setMvsFilename(mvsFilename);
                } else {
                    DataSetReader dsr = new DataSetReader(mvsFilename);
                    jcls.putAll(dsr.getDataSets());
                }
            } else if (!DeploymentHelper.isNullOrEmpty(ussFilename)) {
                jcls.put(ussFilename, SubmitJob.copyUssFileToString(ussFilename));
            } else {
                if (DeploymentHelper.isNullOrEmpty(jclString)) throw new IllegalArgumentException("At least one JCL input (JCL Dataset, JCL File or JCL) must be specified.");
                jcls.put("Step JCL", jclString);
            }
            if (waitForJob) {
                try {
                    int timeoutValue = Integer.parseInt(timeout);
                    if (timeoutValue < 0) {
                        throw new IllegalArgumentException("Time out cannot be a negative integer");
                    }
                    jobUtil.setTimeout(timeoutValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Time Out isn't a number.");
                }
                try {
                    int maxLinesValue = Integer.parseInt(maxLines);
                    if (maxLinesValue < 0) {
                        System.out.println(" [Info] Setting Max lines to JMON limit of 2147483640 lines.");
                        maxLinesValue = 0x7FFFFFF8;
                    }
                    jobUtil.setCutoff(maxLinesValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Max Lines isn't a number.");
                }
                try {
                    int maxRCValue = Integer.parseInt(maxRC);
                    if (maxRCValue < 0) {
                        throw new IllegalArgumentException("Max Return Code cannot be a negative integer");
                    }
                    jobUtil.setMaxReturnCode(maxRCValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Max Return Code isn't a number.");
                }
                jobUtil.setShowOutput(showOutput);
            }
            String[] eachJobTokens = ("\n" + explicitTokensForeachJob).split("\n//");
            ArrayList<String> explicitTokensForeachJobList = new ArrayList<String>();
            for (String jobTokens : eachJobTokens) {
                if (DeploymentHelper.isNullOrEmpty(jobTokens = jobTokens.trim()) || jobTokens.equals("//")) continue;
                explicitTokensForeachJobList.add(jobTokens);
            }
            if (jcls.size() > 1 && explicitTokensForeachJobList.size() > 1) {
                throw new IllegalArgumentException("Replace Token Sets For Each Job must be used with a single JCL.");
            }
            if (explicitTokensForeachJobList.size() == 0) {
                explicitTokensForeachJobList.add("");
            }
            if (jcls.size() > 1) {
                System.out.println("=================================== Total " + jcls.size() + " jobs to submit ============================================================");
            } else if (explicitTokensForeachJobList.size() > 1) {
                System.out.println("=================================== Total " + explicitTokensForeachJobList.size() + " jobs to submit ============================================================");
            }
            if (outputPagination) {
                SubmitJob.configurePrintStream(inputProperties);
            }
            int jobcount = 0;
            int failcount = 0;
            for (String jobLevelTokens : explicitTokensForeachJobList) {
                String mergedTokens = explicitTokens + "\n" + jobLevelTokens;
                mergedTokens = mergedTokens.trim();
                if (!isZos && !DeploymentHelper.isNullOrEmpty(mvsFilename)) {
                    boolean success = SubmitJob.submitOneASCIIJob(jobUtil, waitForJob);
                    ++jobcount;
                    if (success || !stopOnFail) continue;
                    System.out.println("Step failed because Stop On Fail is turned on and job failed.");
                    System.exit(1);
                    continue;
                }
                for (Map.Entry entry : jcls.entrySet()) {
                    boolean success;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    ++jobcount;
                    if (explicitTokensForeachJobList.size() > 1 || jcls.size() > 1) {
                        System.out.println("=================================== Submitting job" + jobcount + " : " + key + " ==================================================================");
                    } else {
                        System.out.println("=================================== Submitting job : " + key + " ==================================================================");
                    }
                    if (usePassticket) {
                        password = PassTicketUtil.generatePassTicket((String)userid, (String)APP_ID, (String)irrracfLibraryPath);
                        jobUtil.setPassword(password);
                    }
                    if (success = SubmitJob.submitOneJob(jobUtil, key, value, jobCard, mergedTokens, waitForJob, jobcount)) continue;
                    ++failcount;
                    if (!stopOnFail) continue;
                    System.out.println("Step failed because Stop On Fail is turned on and job" + jobcount + " : " + key + " failed.");
                    System.exit(1);
                }
            }
            System.out.println(jobcount + " job(s) completed. ");
            apTool.setOutputProperty("jobCount", Integer.toString(jobcount));
            if (failcount > 0) {
                System.out.println(failcount + " job(s) failed. ");
                System.exit(1);
            }
            apTool.storeOutputProperties();
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static void configurePrintStream(Properties inputProperties) throws Exception {
        String inputPropFilePath = inputProperties.getProperty(PLUGIN_INPUT_PROPS).trim();
        Path stdOutfilePath = Paths.get(Paths.get(inputPropFilePath, new String[0]).getParent().toString() + File.separator + STDOUT_TXT, new String[0]);
        int noOfLinesInStdOut = (int)Files.lines(stdOutfilePath).count();
        System.out.println("                    [ Please look at next page for job outputs. You can switch off pagination in this plugin step. ]  ");
        PrintStream origOut = System.out;
        Interceptor interceptor = new Interceptor((OutputStream)origOut, ++noOfLinesInStdOut);
        System.setOut(interceptor);
    }

    private static boolean submitOneJob(JobUtil jobUtil, String jclname, String jcl, String jobCard, String mergedRules, boolean waitForJob, int jobcount) throws Exception {
        jobUtil.setJclString(jcl);
        if (!DeploymentHelper.isNullOrEmpty(mergedRules)) {
            jobUtil.setJclString(SubmitJob.replaceJCL(jcl, mergedRules));
        }
        SubmitJob.checkAndUpdateJobCard(jobUtil, jobCard);
        String jobid = jobUtil.submitJob();
        apTool.setOutputProperty("JobId" + jobcount, jobid);
        apTool.setOutputProperty("JobJCL" + jobcount, jclname);
        apTool.setOutputProperty("JobId", jobid);
        apTool.setOutputProperty("JobJCL", jclname);
        Thread.sleep(500L);
        if (jobUtil.isJclError(jobid)) {
            JESJob job = jobUtil.getJob(jobid, true);
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return false;
        }
        if (waitForJob) {
            boolean success = jobUtil.waitForJob(jobid);
            jobUtil.printLog(jobid);
            JESJob job = jobUtil.getJob(jobid, true);
            apTool.setOutputProperty("JobReturnCode" + jobcount, job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo" + jobcount, job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus" + jobcount, job.getReturnStatus() == null ? "" : job.getReturnStatus());
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return true;
    }

    private static boolean submitOneASCIIJob(JobUtil jobUtil, boolean waitForJob) throws Exception {
        String jobid = jobUtil.submitJob();
        apTool.setOutputProperty("JobId", jobid);
        Thread.sleep(500L);
        if (jobUtil.isJclError(jobid)) {
            JESJob job = jobUtil.getJob(jobid, true);
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return false;
        }
        if (waitForJob) {
            boolean success = jobUtil.waitForJob(jobid);
            jobUtil.printLog(jobid);
            JESJob job = jobUtil.getJob(jobid, true);
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            apTool.setOutputProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return true;
    }

    private static String replaceJCL(String jcl, String tokensToBeReplaced) throws Exception {
        String tokenLine;
        List<String> jclLinesBeforeTokenReplace = SubmitJob.getListFromLines(jcl);
        String jclWithTokensReplaced = jcl;
        BufferedReader reader = new BufferedReader(new StringReader(tokensToBeReplaced));
        int noOfOccurrences = 0;
        while ((tokenLine = reader.readLine()) != null) {
            if (tokenLine.indexOf("->") > 0) {
                int index = tokenLine.indexOf("->");
                String propName = tokenLine.substring(0, index).trim();
                String propValue = index < tokenLine.length() - 2 ? tokenLine.substring(index + 2) : "";
                noOfOccurrences += StringUtils.countMatches((CharSequence)jclWithTokensReplaced, (CharSequence)propName);
                jclWithTokensReplaced = jclWithTokensReplaced.replace(propName, propValue);
                continue;
            }
            throw new IllegalArgumentException("Found invalid explicit token " + tokenLine + " - missing -> separator");
        }
        System.out.println("  [replace] Replaced " + noOfOccurrences + " occurrences in 1 files.");
        System.out.println("========================================================================================================================");
        System.out.println("JCL after replacing token.");
        List<String> reformattedJclLines = SubmitJob.getReformattedJclLines(jclWithTokensReplaced, jclLinesBeforeTokenReplace);
        jclWithTokensReplaced = String.join((CharSequence)"\n", reformattedJclLines);
        System.out.println("========================================================================================================================");
        System.out.println(jclWithTokensReplaced);
        return jclWithTokensReplaced;
    }

    private static List<String> getReformattedJclLines(String jclWithTokensReplaced, List<String> jclLinesBeforeTokenReplace) throws Exception {
        String jclLineAfterTokenReplace;
        int lineNo = 0;
        ArrayList<String> reformattedJclLines = new ArrayList<String>();
        BufferedReader jclLinesReader = new BufferedReader(new StringReader(jclWithTokensReplaced));
        while ((jclLineAfterTokenReplace = jclLinesReader.readLine()) != null) {
            if (jclLineAfterTokenReplace.startsWith("//*")) {
                reformattedJclLines.add(jclLineAfterTokenReplace);
                ++lineNo;
                continue;
            }
            byte[] jclLineBytesAfterTokenReplace = jclLineAfterTokenReplace.getBytes(encoding);
            int lengthOfJclLineAfterTokenReplace = jclLineBytesAfterTokenReplace.length;
            byte[] jclLineBytesBeforeTokenReplace = jclLinesBeforeTokenReplace.get(lineNo).getBytes(encoding);
            int lengthOfJclLineBeforeTokenReplace = jclLineBytesBeforeTokenReplace.length;
            if (lengthOfJclLineBeforeTokenReplace == 80) {
                if (lengthOfJclLineAfterTokenReplace < 80) {
                    reformattedJclLines.add(SubmitJob.createStringAfterFillingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, 80));
                } else if (lengthOfJclLineAfterTokenReplace == 80) {
                    reformattedJclLines.add(jclLineAfterTokenReplace);
                } else {
                    reformattedJclLines.add(SubmitJob.createStringAfterRemovingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, 80, lineNo, jclLineAfterTokenReplace));
                }
            } else if (lengthOfJclLineBeforeTokenReplace == 72 && jclLineBytesBeforeTokenReplace[71] != byte4WhiteSpace) {
                if (lengthOfJclLineAfterTokenReplace < 72) {
                    reformattedJclLines.add(SubmitJob.createStringAfterFillingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, 72));
                } else if (lengthOfJclLineAfterTokenReplace == 72) {
                    reformattedJclLines.add(jclLineAfterTokenReplace);
                } else {
                    reformattedJclLines.add(SubmitJob.createStringAfterRemovingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, 72, lineNo, jclLineAfterTokenReplace));
                }
            } else if (lengthOfJclLineBeforeTokenReplace > 72) {
                reformattedJclLines.add(SubmitJob.createStringAfterRemovingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, lengthOfJclLineBeforeTokenReplace, lineNo, jclLineAfterTokenReplace));
            } else if (lengthOfJclLineAfterTokenReplace <= 71) {
                reformattedJclLines.add(jclLineAfterTokenReplace);
            } else {
                reformattedJclLines.add(SubmitJob.createStringAfterRemovingBlanks(jclLineBytesBeforeTokenReplace, jclLineBytesAfterTokenReplace, 71, lineNo, jclLineAfterTokenReplace));
            }
            ++lineNo;
        }
        if (contentExceedMaxNum) {
            throw new IllegalArgumentException("Job not submitted because the content exceed 71 bytes after replacing tokens.");
        }
        return reformattedJclLines;
    }

    private static List<String> getListFromLines(String stringWithLines) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWithLines));
        ArrayList<String> listOfLines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            listOfLines.add(line);
        }
        return listOfLines;
    }

    private static void checkAndUpdateJobCard(JobUtil jobUtil, String jobCard) {
        String jcl = jobUtil.getJclString();
        String[] jclLines = jcl.split("\n");
        String firstLine = jclLines[0];
        String regex = "\\bJOB\\b";
        Pattern pattern = Pattern.compile(regex);
        Matcher jclMatcher = pattern.matcher(firstLine);
        if (!jclMatcher.find() || !firstLine.startsWith("//")) {
            System.out.println(" [Info] No JOB statement found in the JCL.");
            if (!DeploymentHelper.isNullOrEmpty(jobCard)) {
                System.out.println(" [Info] Adding default JOB statement");
                String[] jobCardLines = jobCard.split("\n");
                String firstLineJobCard = jobCardLines[0];
                Matcher jobCardMatcher = pattern.matcher(firstLineJobCard);
                if (!jobCardMatcher.find() || !firstLineJobCard.startsWith("//")) {
                    throw new IllegalArgumentException(" [Error] JOB statement must be provided in the first line in the default Job card.");
                }
                jobUtil.setJclString(jobCard + "\n" + jcl);
            } else {
                System.out.println(" [Info] No default job card statement found");
                throw new IllegalArgumentException(" [Error] JOB statement must be provided in the first line of JCL.");
            }
        }
    }

    private static String createStringAfterRemovingBlanks(byte[] jclRecordBytesBeforeTokenReplace, byte[] jclRecordBytesAfterTokenReplace, int availableJclLineLength, int lineNumber, String lineAfterTokenReplace) throws Exception {
        int remainLength = availableJclLineLength - 71;
        byte[] bytesAfterMetaInfoReformat = new byte[availableJclLineLength];
        Arrays.fill(bytesAfterMetaInfoReformat, byte4WhiteSpace);
        String createdString = "";
        int jclRecordLengthWithoutLineMetaInfoAndSpaces = jclRecordBytesAfterTokenReplace.length - remainLength;
        while (jclRecordBytesAfterTokenReplace[--jclRecordLengthWithoutLineMetaInfoAndSpaces] == byte4WhiteSpace) {
        }
        if (++jclRecordLengthWithoutLineMetaInfoAndSpaces > 71) {
            System.out.println("Error: line " + (lineNumber + 1) + " exceeds " + 71 + " bytes.");
            System.out.println(lineNumber + 1 + ":" + lineAfterTokenReplace);
            contentExceedMaxNum = true;
        } else {
            System.arraycopy(jclRecordBytesAfterTokenReplace, 0, bytesAfterMetaInfoReformat, 0, jclRecordLengthWithoutLineMetaInfoAndSpaces);
            if (remainLength > 0) {
                System.arraycopy(jclRecordBytesBeforeTokenReplace, 71, bytesAfterMetaInfoReformat, 71, remainLength);
            }
            createdString = new String(bytesAfterMetaInfoReformat, encoding);
        }
        return createdString;
    }

    private static String createStringAfterFillingBlanks(byte[] jclRecordBytesBeforeTokenReplace, byte[] jclRecordBytesAfterTokenReplace, int availableJclLineLength) throws Exception {
        int remainLength = availableJclLineLength - 71;
        byte[] bytesAfterMetaInfoReformat = new byte[availableJclLineLength];
        Arrays.fill(bytesAfterMetaInfoReformat, byte4WhiteSpace);
        int jclRecordLengthWithoutLineMetaInfo = jclRecordBytesAfterTokenReplace.length - remainLength;
        System.arraycopy(jclRecordBytesAfterTokenReplace, 0, bytesAfterMetaInfoReformat, 0, jclRecordLengthWithoutLineMetaInfo);
        System.arraycopy(jclRecordBytesBeforeTokenReplace, 71, bytesAfterMetaInfoReformat, 71, remainLength);
        return new String(bytesAfterMetaInfoReformat, encoding);
    }

    private static String copyUssFileToString(String ussFileName) throws Exception {
        String sCurrentLine;
        File ussFile = new File(ussFileName);
        if (!ussFile.exists() || !ussFile.isFile()) {
            throw new IllegalArgumentException(" File " + ussFileName + " does not exist");
        }
        if (!ussFile.canRead()) {
            throw new IllegalArgumentException(" User do not have READ permission for file " + ussFileName);
        }
        StringBuilder contentBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(ussFileName));
        while ((sCurrentLine = br.readLine()) != null) {
            contentBuilder.append(sCurrentLine).append("\n");
        }
        br.close();
        String ussFileData = contentBuilder.toString();
        if (DeploymentHelper.isNullOrEmpty(ussFileData)) {
            throw new IllegalArgumentException("File " + ussFileName + " is empty.");
        }
        return ussFileData;
    }

    static {
        contentExceedMaxNum = false;
    }
}

