/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.DeploymentHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.File;
import java.util.Properties;

public class CleanupBackupFiles {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String resourceId = DeploymentHelper.getStringInput(inputProperties.getProperty("resourceId"));
            String componentName = DeploymentHelper.getStringInput(inputProperties.getProperty("componentName"));
            String versionName = DeploymentHelper.getStringInput(inputProperties.getProperty("versionName"));
            String deployBasePath = DeploymentHelper.getStringInput(inputProperties.getProperty("deployBasePath"));
            if (DeploymentHelper.isNullOrEmpty(deployBasePath)) {
                throw new IllegalArgumentException(" [Error] Deployment Base Path is either null or empty");
            }
            if (DeploymentHelper.isNullOrEmpty(versionName)) {
                throw new IllegalArgumentException(" [Error] Version Name is either null or empty");
            }
            if (DeploymentHelper.isNullOrEmpty(componentName)) {
                throw new IllegalArgumentException(" [Error] Component Name is either null or empty");
            }
            if (DeploymentHelper.isNullOrEmpty(resourceId)) {
                throw new IllegalArgumentException(" [Error] Resource Id is either null or empty");
            }
            File deployBasePathForVersion = new File(DeploymentHelper.getVersionPathInDeployBasePath(deployBasePath, resourceId, componentName, versionName, true));
            if (!deployBasePathForVersion.canWrite()) {
                throw new IllegalArgumentException(" [Error] User do not have WRITE permission to directory " + deployBasePathForVersion.getCanonicalPath());
            }
            DeploymentHelper.printActionTitle("Cleaning up backup files from " + deployBasePathForVersion.getCanonicalPath());
            if (!FileHelper.deleteDirectory(deployBasePathForVersion)) {
                throw new IllegalArgumentException(" [Error] Failed to delete files from " + deployBasePathForVersion.getCanonicalPath());
            }
            System.out.println();
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

