/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class RollbackManifestParser {
    private static final String TypeKey = "type";
    private static final String NameKey = "name";
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String CONTAINER_TYPE_SEQ_VALUE = "sequential";
    private static final String CreatedTag = "created";
    private static final String UpdatedTag = "updated";
    private static final String DeletedTag = "deleted";
    private static final String ContainerTag = "container";
    private static final String ResourceTag = "resource";
    private static final String rollbackManifestFileEncoding = "CP037";

    public static HashMap<String, HashMap<String, Set<String>>> parseDataFromRollbackXml(InputStream rollbackInputStream) throws XMLStreamException {
        HashMap<String, HashMap<String, Set<String>>> parsedRollbackDataMap = new HashMap<String, HashMap<String, Set<String>>>();
        HashMap containerMap = new HashMap();
        HashSet<String> resourceSet = new HashSet<String>();
        String parsedRollbackDataMapKey = null;
        String containerMapKey = null;
        boolean nestedInActionTag = false;
        boolean nestedInPDSContainer = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4RollbackXml = null;
        eventReader4RollbackXml = inputFactory.createXMLEventReader(rollbackInputStream, rollbackManifestFileEncoding);
        block8: while (eventReader4RollbackXml.hasNext()) {
            XMLEvent shipListReaderEvent = eventReader4RollbackXml.nextEvent();
            switch (shipListReaderEvent.getEventType()) {
                case 7: {
                    break;
                }
                case 1: {
                    StartElement startElement = shipListReaderEvent.asStartElement();
                    String nodeName = startElement.getName().getLocalPart().trim();
                    if (CreatedTag.equalsIgnoreCase(nodeName) || UpdatedTag.equalsIgnoreCase(nodeName) || DeletedTag.equalsIgnoreCase(nodeName)) {
                        nestedInActionTag = true;
                        parsedRollbackDataMapKey = nodeName;
                        break;
                    }
                    if (!nestedInActionTag) break;
                    if (ContainerTag.equalsIgnoreCase(nodeName)) {
                        String containerType = RollbackManifestParser.getAttributeValue(startElement, TypeKey);
                        String containerName = RollbackManifestParser.getAttributeValue(startElement, NameKey);
                        if (containerType.equalsIgnoreCase(CONTAINER_TYPE_PDS_VALUE)) {
                            nestedInPDSContainer = true;
                            containerMapKey = containerName;
                            break;
                        }
                        nestedInPDSContainer = false;
                        if (!containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQ_VALUE)) continue block8;
                        resourceSet = new HashSet();
                        containerMap.put(containerName, resourceSet);
                        break;
                    }
                    if (!ResourceTag.equalsIgnoreCase(nodeName) || !nestedInPDSContainer) break;
                    String resourceName = RollbackManifestParser.getAttributeValue(startElement, NameKey);
                    resourceSet.add(resourceName);
                    break;
                }
                case 8: {
                    break;
                }
                case 2: {
                    EndElement endElement = shipListReaderEvent.asEndElement();
                    String endNodeName = endElement.getName().getLocalPart().trim();
                    if (CreatedTag.equalsIgnoreCase(endNodeName) || UpdatedTag.equalsIgnoreCase(endNodeName) || DeletedTag.equalsIgnoreCase(endNodeName)) {
                        parsedRollbackDataMap.put(parsedRollbackDataMapKey, containerMap);
                        containerMap = new HashMap();
                        resourceSet = new HashSet();
                        containerMapKey = null;
                        nestedInActionTag = false;
                        nestedInPDSContainer = false;
                        break;
                    }
                    if (!ContainerTag.equalsIgnoreCase(endNodeName) || !nestedInPDSContainer) break;
                    containerMap.put(containerMapKey, resourceSet);
                    nestedInPDSContainer = false;
                    containerMapKey = null;
                    resourceSet = new HashSet();
                    break;
                }
            }
        }
        return parsedRollbackDataMap;
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        String attrValue = null;
        QName qn = new QName(attributeName);
        Attribute attribute = startElement.getAttributeByName(qn);
        if (null != attribute) {
            attrValue = attribute.getValue().trim();
        }
        return attrValue;
    }
}

