/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasetHelper {
    public static Map<String, String> searchNonVsamDataset(String pattern) {
        int max = -1;
        CatalogSearch catSearch = new CatalogSearch(pattern);
        catSearch.setEntryTypes(new String("A"));
        catSearch.addFieldName("ENTNAME");
        catSearch.addFieldName("VOLSER");
        catSearch.search();
        HashMap<String, String> result = new HashMap<String, String>();
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            CatalogSearchField datasetName = entry.getField("ENTNAME");
            CatalogSearchField volume = entry.getField("VOLSER");
            if (max >= 0 && (max <= 0 || result.size() > max)) break;
            result.put(datasetName.getFString().trim(), volume.getFString().trim());
        }
        return result;
    }

    public static List<String> getMembers(String datasetName, String volume, String memberPattern) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String pattern = DatasetHelper.makeRegexPattren(memberPattern);
        DSCB[] dscb = ZFile.readDSCBChain((String)DatasetHelper.getSlashSlashQuotedDSN(datasetName), (String)volume);
        int fmtDSCB = 0;
        try {
            fmtDSCB = ((Format1DSCB)dscb[0]).getDS1DSORG();
        }
        catch (Exception e1) {
            try {
                fmtDSCB = ((Format8DSCB)dscb[0]).getDS1DSORG();
            }
            catch (Exception e2) {
                System.out.println("DSCB found was neither of Format1DSCB nor Format8DSCB");
                e2.printStackTrace();
                System.exit(1);
            }
        }
        if (fmtDSCB == 16384) {
            result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
        } else if (fmtDSCB == 512 && !DatasetHelper.isNullOrEmpty(memberPattern.trim())) {
            PdsDirectory pds = new PdsDirectory(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
            for (PdsDirectory.MemberInfo member : pds) {
                String memberName = member.getName();
                if (!memberName.matches(pattern)) continue;
                result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName + "(" + memberName + ")"));
            }
            pds.close();
        }
        return result;
    }

    public static String getSlashSlashQuotedDSN(String datasetName) {
        return ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
    }

    public static String makeRegexPattren(String memberPattern) {
        String pattern = memberPattern;
        pattern = pattern.replace("$", "\\$");
        pattern = pattern.replace("-", "\\-");
        pattern = pattern.replace("(", "\\(");
        pattern = pattern.replace(")", "\\)");
        pattern = pattern.replace("*", ".*");
        return pattern;
    }

    public static String getDatasetRecFM(String dsnName) {
        int INVALID_FILTER_KEY = 122;
        int CATALOG_ERROR = 100;
        int FB = 144;
        int VB = 80;
        int U = 192;
        int FBS = 136;
        int VBS = 72;
        String recFM = "";
        Integer intRecFM = 0;
        String filterKey = dsnName.toUpperCase();
        CatalogSearch catSearch = new CatalogSearch(filterKey, 64000);
        try {
            catSearch.addFieldName("ENTNAME");
            catSearch.addFieldName("VOLSER");
            catSearch.search();
            while (catSearch.hasNext()) {
                CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
                if (!entry.isDatasetEntry()) continue;
                CatalogSearchField field = entry.getField("ENTNAME");
                String dsn = field.getFString().trim();
                String qdsn = "'" + dsn + "'";
                field = entry.getField("VOLSER");
                String volser = field.getFString().trim();
                if (volser == null || volser.length() == 0) continue;
                String resolvedName = volser;
                if (volser.indexOf(38) != -1) {
                    try {
                        resolvedName = ZUtil.substituteSystemSymbols((String)volser, (boolean)true);
                    }
                    catch (RcException rce) {
                        System.out.println("Could not resolve symbolic VOLSER '" + volser + "'.  Skipping...");
                        continue;
                    }
                }
                try {
                    DSCB[] dscb = ZFile.readDSCBChain((String)qdsn, (String)resolvedName);
                    try {
                        intRecFM = ((Format1DSCB)dscb[0]).getDS1RECFM();
                    }
                    catch (Exception e1) {
                        try {
                            intRecFM = ((Format8DSCB)dscb[0]).getDS1RECFM();
                        }
                        catch (Exception e2) {
                            System.out.println("DSCB found was neither of Format1DSCB nor Format8DSCB");
                            e2.printStackTrace();
                            System.exit(1);
                        }
                    }
                    switch (intRecFM) {
                        case 144: {
                            recFM = "F,B";
                            break;
                        }
                        case 80: {
                            recFM = "V,B";
                            break;
                        }
                        case 192: {
                            recFM = "U";
                            break;
                        }
                        case 136: {
                            recFM = "F,B,S";
                            break;
                        }
                        case 72: {
                            recFM = "V,B,S";
                        }
                    }
                }
                catch (RcException rce) {
                    String reason = "";
                    if (rce.getRc() == 4) {
                        reason = " Volume not mounted";
                    } else if (rce.getRc() == 8) {
                        reason = " Volume does not contain a format 1 DSCB for dataset";
                    }
                    System.out.println(qdsn + " on " + resolvedName + reason);
                }
            }
        }
        catch (RcException rce) {
            if (rce.getRc() == 4 && catSearch.getRc() == 122) {
                System.out.println("Invalid filter key provided: " + filterKey);
            }
            if (rce.getRc() == 4 && catSearch.getRc() == 100) {
                while (catSearch.hasNext()) {
                    CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
                    if (!entry.hasError()) continue;
                    System.out.println("Entry Exception: ENTRY_RC=" + entry.getRc() + ", ENTRY_Reason=" + entry.getReason());
                }
            }
            throw rce;
        }
        return recFM;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

