/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;
import java.util.regex.Pattern;

public class DeleteDataset {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            String line;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String inDatasetNames = inputProperties.getProperty("datasetName").trim();
            String membersList = inputProperties.getProperty("membersList").trim();
            if (GenericHelper.isNullOrEmpty(inDatasetNames)) {
                System.out.println(" [Error] Dataset Name cannot be empty.");
                System.exit(1);
            }
            if (inDatasetNames.contains("*") || inDatasetNames.contains("%")) {
                System.out.println(" [Error] Wildcards (*) or (%) are not allowed in the dataset names to be deleted.");
                System.exit(1);
            }
            if (membersList.contains("*") || membersList.contains("%")) {
                System.out.println(" [Error] Wildcards (*) or (%) are not allowed in the member names to be deleted.");
                System.exit(1);
            }
            BufferedReader bufReader = new BufferedReader(new StringReader(inDatasetNames));
            int lineNo = 0;
            while ((line = bufReader.readLine()) != null) {
                ++lineNo;
                if (GenericHelper.isNullOrEmpty(line)) continue;
                if (Pattern.matches(".*\\([+-]?\\d*\\).*", line)) {
                    System.out.println(" [Error] Found GDG dataset with relative generation number at line no " + lineNo + " and is not supported.");
                    System.exit(1);
                }
                String datasetName = DeleteDataset.getResolvedDataset(line);
                if (!GenericHelper.isNullOrEmpty(membersList)) {
                    if (bufReader.readLine() != null) {
                        System.out.println(" [Error] Dataset name must contain only one PDS for deleting members specified in members list");
                        System.exit(1);
                    }
                    DeleteDataset.deleteDatasetMembers(datasetName, membersList);
                    break;
                }
                String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
                if (!ZFile.dsExists((String)zFileDsn)) {
                    System.out.println(" [Warning] Dataset " + datasetName + " at line no " + lineNo + " does not exist.");
                    continue;
                }
                ZFile.remove((String)zFileDsn);
                System.out.println(" [Info] Deleted " + datasetName);
            }
            System.exit(0);
        }
        catch (ZFileException zfe) {
            System.out.println(" [Error] Operation failed for dataset - " + zfe.getFileName());
            System.out.println(zfe.getErrnoMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static String getResolvedDataset(String s) {
        String datasetName = (s = s.trim()).startsWith("'") ? s.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)s);
        return datasetName;
    }

    private static void deleteDatasetMembers(String datasetName, String membersList) throws Exception {
        String member;
        String zPdsDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
        if (!ZFile.dsExists((String)zPdsDsn)) {
            System.out.println(" [Warning] Dataset " + datasetName + " does not exist.");
            return;
        }
        System.out.println("....Deleting members in PDS " + datasetName);
        BufferedReader reader = new BufferedReader(new StringReader(membersList));
        while ((member = reader.readLine()) != null) {
            if (GenericHelper.isNullOrEmpty(member)) continue;
            member = member.trim();
            String pdsMember = datasetName + "(" + member + ")";
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)pdsMember, (boolean)true);
            if (!ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [Warning] Skipped deleting " + member + " as member does not exist.");
                continue;
            }
            ZFile.remove((String)zFileDsn);
            System.out.println(" [Info] Deleted " + member);
        }
    }
}

