/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ExternalRepository {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String ZIP_EXTENSION = ".zip";
    private static final String TYPE_ARTIFACTORY = "ARTIFACTORY";
    private static final String TYPE_NEXUS = "NEXUS";
    private static final String EXTERNAL_REPOSITORY_LCNAME = "repository";
    private static final String NEXUS_REST_END_POINT = "/service/rest/v1/components?repository=";
    private static final String EXTERNAL_REPOSITORY_URL = "URL";
    private static final String EXTERNAL_REPOSITORY_USERNAME = "USERNAME";
    private static final String EXTERNAL_REPOSITORY_APIKEY = "APIKEY";
    private static final String EXTERNAL_REPOSITORY_PASSWORD = "PASSWORD";
    private static final String EXTERNAL_REPOSITORY_TYPE = "REPOSITORY_TYPE";
    private static final String EXTERNAL_REPOSITORY_NAME = "REPOSITORY";
    private static final String NEXUS_RAW_DIRECTORY = "RAWDIRECTORY";
    private static final String EXTERNAL_HTTP_PROXY_HOST = "HTTPPROXYHOST";
    private static final String EXTERNAL_HTTP_PROXY_PORT = "HTTPPROXYPORT";
    private final String versionName;
    private final File versionZip;
    private String urlToDownloadZip;
    private String postUrl;
    private int EXTERNAL_REPO_RESPONSE_CODE;
    private String extRepohttpProxyPort;
    private String extRepohttpProxyHost;
    private String extRepoUsername;
    private String extRepoPassword;
    private String extRepoUrl;
    private String extRepoRawDirectory;
    private String extRepoApiKey;
    private String extRepoRepositoryName;
    private String extRepoRepositoryType;
    private String responseBody;
    private final ResponseHandler<String> responseHandler = response -> {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity;
            if (status == this.EXTERNAL_REPO_RESPONSE_CODE) {
                this.printLogMessage("Version artifacts stored in " + this.extRepoRepositoryType + " server");
            }
            return (entity = response.getEntity()) != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        System.out.println("HTTP response error code =" + response.getStatusLine().getStatusCode());
        throw new IOException("Bad request status code" + response.getStatusLine().getStatusCode() + response.toString().replace("\n", ""));
    };

    public ExternalRepository(Properties extRepoProperties, Map<String, String> argsMap, String versionZipPath, String packageName) {
        this.externalRepoPropertiesBuilder(extRepoProperties, argsMap);
        this.versionName = packageName;
        this.versionZip = new File(versionZipPath);
    }

    public String getUrlToDownloadZip() {
        return this.urlToDownloadZip;
    }

    public String getExtRepoRepositoryType() {
        return this.extRepoRepositoryType;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void uploadToExternalRepo() throws Exception {
        this.externalRepoArgumentValidator();
        if (this.extRepoRepositoryType.equals(TYPE_ARTIFACTORY)) {
            this.EXTERNAL_REPO_RESPONSE_CODE = 201;
            this.urlToDownloadZip = this.extRepoUrl + FILE_SEPARATOR + this.extRepoRepositoryName + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION;
            this.postUrl = this.extRepoUrl + FILE_SEPARATOR + this.extRepoRepositoryName;
            this.printLogMessage("Uploading artifacts to " + this.extRepoRepositoryType);
            this.uploadToArtifactory(this.versionZip);
        } else {
            this.EXTERNAL_REPO_RESPONSE_CODE = 204;
            this.urlToDownloadZip = this.extRepoUrl + FILE_SEPARATOR + EXTERNAL_REPOSITORY_LCNAME + FILE_SEPARATOR + this.extRepoRepositoryName + FILE_SEPARATOR + this.extRepoRawDirectory + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION;
            this.postUrl = this.extRepoUrl + NEXUS_REST_END_POINT + this.extRepoRepositoryName;
            this.printLogMessage("Uploading artifacts to " + this.extRepoRepositoryType);
            this.uploadToNexus(this.versionZip);
        }
    }

    private void uploadToArtifactory(File versionZip) throws Exception {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(this.extRepoUsername);
        builder.setPassword(this.extRepoPassword);
        if (!this.emptyString(this.extRepohttpProxyHost)) {
            this.printLogMessage("Using Proxy Host : " + this.extRepohttpProxyHost);
            builder.setProxyHost(this.extRepohttpProxyHost);
        }
        if (!this.emptyString(this.extRepohttpProxyPort)) {
            this.printLogMessage("Using Proxy Port : " + this.extRepohttpProxyPort);
            int httpProxyPortNumber = Integer.parseInt(this.extRepohttpProxyPort);
            builder.setProxyPort(httpProxyPortNumber);
        }
        ContentType contentType = ContentType.create((String)"application/octet-stream");
        FileEntity fileEntity = new FileEntity(versionZip, contentType);
        HttpPut put = new HttpPut(this.postUrl + FILE_SEPARATOR + this.versionName + ZIP_EXTENSION);
        put.addHeader("Content-Encoding", "application/octet-stream");
        put.setEntity((HttpEntity)fileEntity);
        this.printLogMessage("Executing request " + put.getRequestLine());
        try (CloseableHttpClient client = builder.buildClient();){
            this.responseBody = (String)client.execute((HttpUriRequest)put, this.responseHandler);
        }
    }

    private void uploadToNexus(File versionZip) throws Exception {
        String auth = this.extRepoUsername + ":" + this.extRepoPassword;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + encodedAuth;
        HttpEntity data = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("raw.assetN", versionZip, ContentType.DEFAULT_BINARY, versionZip.getName()).addTextBody("raw.assetN.filename", this.versionName + ZIP_EXTENSION, ContentType.DEFAULT_TEXT).addTextBody("raw.directory", this.extRepoRawDirectory, ContentType.DEFAULT_TEXT).build();
        HttpUriRequest request = RequestBuilder.post((String)this.postUrl).setEntity(data).addHeader("Authorization", authHeader).build();
        this.printLogMessage("Executing request " + request.getRequestLine());
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            this.responseBody = (String)httpClient.execute(request, this.responseHandler);
        }
    }

    private void externalRepoPropertiesBuilder(Properties extRepoProperties, Map<String, String> argsMap) {
        this.extRepohttpProxyHost = this.emptyString(argsMap.get("-extrepo.httpproxyhost")) ? extRepoProperties.getProperty(EXTERNAL_HTTP_PROXY_HOST, "") : argsMap.get("-extrepo.httpProxyPort");
        this.extRepohttpProxyPort = this.emptyString(argsMap.get("-extrepo.httpproxyport")) ? extRepoProperties.getProperty(EXTERNAL_HTTP_PROXY_PORT, "") : argsMap.get("-extrepo.httpProxyPort");
        this.extRepoUsername = this.emptyString(argsMap.get("-extrepo.username")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_USERNAME, "") : argsMap.get("-extrepo.username");
        String string = this.extRepoPassword = this.emptyString(argsMap.get("-extrepo.password")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_PASSWORD, "") : argsMap.get("-extrepo.password");
        if (argsMap.get("-extrepo.password") != null) {
            System.out.println("                                          !!!!  WARNING  !!!!");
            System.out.println("!!!!  passing password on command line isn't regarded safe, consider storing password in a access restricted file\n which will be encrypted in the file the first time it is used !!!!");
        }
        this.extRepoUrl = this.emptyString(argsMap.get("-extrepo.url")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_URL, "") : argsMap.get("-extrepo.url");
        this.extRepoRepositoryType = this.emptyString(argsMap.get("-extrepo.repositorytype")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_TYPE, "") : argsMap.get("-extrepo.repositorytype");
        this.extRepoRepositoryType = this.extRepoRepositoryType.toUpperCase();
        this.extRepoRepositoryName = this.emptyString(argsMap.get("-extrepo.repository")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_NAME, "") : argsMap.get("-extrepo.repository");
        this.extRepoApiKey = this.emptyString(argsMap.get("-extrepo.apikey")) ? extRepoProperties.getProperty(EXTERNAL_REPOSITORY_APIKEY, "") : argsMap.get("-extrepo.apikey");
        this.extRepoRawDirectory = this.emptyString(argsMap.get("-extrepo.rawdirectory")) ? extRepoProperties.getProperty(NEXUS_RAW_DIRECTORY, "") : argsMap.get("-extrepo.rawdirectory");
    }

    private void externalRepoArgumentValidator() {
        this.printLogMessage("External repo properties validation:");
        if (this.emptyString(this.extRepoUsername)) {
            throw new IllegalArgumentException("User name is a mandatory argument for external repository. ");
        }
        if (this.emptyString(this.extRepoRepositoryType)) {
            throw new IllegalArgumentException("External repository type is a mandatory input. Artifactory (or) Nexus are valid values ");
        }
        if (!this.extRepoRepositoryType.equals(TYPE_ARTIFACTORY) && !this.extRepoRepositoryType.equals(TYPE_NEXUS)) {
            System.out.println(" the external repo type is " + this.extRepoRepositoryType);
            throw new IllegalArgumentException("Invalid external repository type. Only Artifactory (or) Nexus are valid values ");
        }
        if (this.emptyString(this.extRepoUrl)) {
            throw new IllegalArgumentException("url was not provided for external repository");
        }
        if (this.emptyString(this.extRepoRepositoryName)) {
            throw new IllegalArgumentException("Repository name/path was not provided for external repository");
        }
        if (this.emptyString(this.extRepoApiKey) && this.emptyString(this.extRepoPassword)) {
            throw new IllegalArgumentException("\"Password\" (or) \"APIKey\" is mandatory argument for external repository");
        }
        if (!this.emptyString(this.extRepoApiKey)) {
            this.extRepoPassword = this.extRepoApiKey;
        }
        if (this.extRepoRepositoryType.equals(TYPE_NEXUS) && this.emptyString(this.extRepoRawDirectory)) {
            throw new IllegalArgumentException("\"Raw directory\" is mandatory argument for storing artifacts in Nexus");
        }
    }

    private void printLogMessage(String message) {
        System.out.println("...." + message);
    }

    private boolean emptyString(String str) {
        return null == str || str.trim().length() == 0;
    }
}

