/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;

public class AllocateLike {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            String allocCommand;
            String ddName;
            String likeDatasetName;
            String zFileLikeDsn;
            String datasetName;
            String zFileDsn;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("datasetName").trim();
            String inlikeDatasetName = inputProperties.getProperty("likeDatasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(inputProperties.getProperty("deleteDataset"));
            String volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = inputProperties.getProperty("spaceUnit").trim();
            int primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            if (GenericHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                System.exit(1);
            }
            if (ZFile.dsExists((String)(zFileDsn = ZFile.getSlashSlashQuotedDSN((String)(datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName)), (boolean)true)))) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    System.exit(1);
                }
            }
            if (GenericHelper.isNullOrEmpty(inlikeDatasetName)) {
                System.out.println(" [Error] Like data set name can not be empty.");
                System.exit(1);
            }
            if (!ZFile.dsExists((String)(zFileLikeDsn = ZFile.getSlashSlashQuotedDSN((String)(likeDatasetName = inlikeDatasetName.startsWith("'") ? inlikeDatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)inlikeDatasetName)), (boolean)true)))) {
                System.out.println(" [ERROR] Like Dataset " + likeDatasetName + " does not exist");
                System.exit(1);
            }
            if (likeDatasetName.contains("(")) {
                ddName = ZFile.allocDummyDDName();
                allocCommand = "alloc fi(" + ddName + ") da(" + likeDatasetName + ") reuse shr msg(wtp)";
                ZFile.bpxwdyn((String)allocCommand);
                likeDatasetName = MVSHelper.getGDGActualName(ddName);
                ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            }
            ddName = ZFile.allocDummyDDName();
            allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") like(" + likeDatasetName + ")";
            if (primaryQuantity > 0 && secondaryQuantity > 0) {
                allocCommand = allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
                if (spaceUnit.equals("TRACKS") || spaceUnit.equals("CYL")) {
                    allocCommand = allocCommand + " " + spaceUnit;
                }
            }
            if (!GenericHelper.isNullOrEmpty(volumeSerial)) {
                allocCommand = allocCommand + " vol(" + volumeSerial + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Command: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                datasetName = MVSHelper.getGDGActualName(ddName);
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                apTool.setOutputProperty("DatasetName", datasetName);
                apTool.storeOutputProperties();
                System.exit(0);
            } else {
                System.out.println(" [Error] Failed to create dataset " + datasetName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

