/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.InvalidInputException;
import com.ibm.urbancode.zos.common.util.MissingInputException;
import java.util.Properties;
import java.util.regex.Pattern;

public class DeleteDatasetInput {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final String datasets;
    private final String members;
    private final String tempDsnPrefix;
    private final String ispfGatewayBinariesPath;

    public DeleteDatasetInput(Properties inputProperties) {
        this.datasets = inputProperties.getProperty("datasetName").trim();
        this.members = inputProperties.getProperty("membersList").trim();
        this.tempDsnPrefix = inputProperties.getProperty("tempDsnPrefix").trim().isEmpty() ? ZFile.getDefaultHLQ() : inputProperties.getProperty("tempDsnPrefix").trim();
        this.ispfGatewayBinariesPath = inputProperties.getProperty("ispfGatewayPath").trim();
    }

    public void validateInputs() {
        if (this.datasets.isEmpty()) {
            throw new MissingInputException("Datasets cannot be empty.");
        }
        if (Pattern.matches(".+\\([+-]?\\d+\\).*", this.datasets)) {
            throw new InvalidInputException("GDG dataset with relative generation number is not supported.");
        }
        this.checkForAnyWildcards();
        if (this.hasMultipleDatasetsWithMemberList()) {
            throw new InvalidInputException("Datasets must contain only one PDS for deleting members specified in members list.");
        }
        if (this.hasDatasetWithMemberAlongWithMemberList()) {
            throw new InvalidInputException("Datasets contain member along with member list.");
        }
        if (this.ispfGatewayBinariesPath.isEmpty()) {
            throw new MissingInputException("ISPF Gateway Path cannot be empty.");
        }
    }

    private void checkForAnyWildcards() {
        if (this.members.contains("*") || this.members.contains("%")) {
            throw new InvalidInputException("Wildcards (*) or (%) are not allowed in the member names to be deleted.");
        }
        if (this.datasets.contains("*") || this.datasets.contains("%")) {
            throw new InvalidInputException("Wildcards (*) or (%) are not allowed in the datasets to be deleted.");
        }
    }

    private boolean hasDatasetWithMemberAlongWithMemberList() {
        return Pattern.matches(".+\\(.+\\).*", this.datasets) && !this.members.isEmpty();
    }

    private boolean hasMultipleDatasetsWithMemberList() {
        return this.datasets.contains(LINE_SEPARATOR) && !this.members.isEmpty();
    }

    public String getDatasets() {
        return this.datasets;
    }

    public String getMembers() {
        return this.members;
    }

    public String getDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public String getIspfGatewayBinariesPath() {
        return this.ispfGatewayBinariesPath;
    }
}

