/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.urbancode.zos.common.util.MissingInputException;
import java.util.Properties;

public class DeployPackageInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String COMPONENT_ID = "componentId";
    public static final String COMPONENT_NAME = "componentName";
    private final String resourceId;
    private final String componentId;
    private final String componentName;

    public DeployPackageInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
    }

    public void validateInputs() {
        this.checkIfEmpty(this.resourceId, "Resource Id");
        this.checkIfEmpty(this.componentId, "Component Id");
        this.checkIfEmpty(this.componentName, "Component Name");
    }

    private void checkIfEmpty(String inputValue, String inputName) {
        if (inputValue.isEmpty()) {
            throw new MissingInputException(inputName + " cannot be empty.");
        }
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }
}

