/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.JDeploymentHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.File;
import java.util.Properties;

public class CleanupBackupFiles {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String resourceId = JDeploymentHelper.getStringInput(inputProperties.getProperty("resourceId"));
            String componentName = JDeploymentHelper.getStringInput(inputProperties.getProperty("componentName"));
            String versionName = JDeploymentHelper.getStringInput(inputProperties.getProperty("versionName"));
            String deployBasePath = JDeploymentHelper.getStringInput(inputProperties.getProperty("deployBasePath"));
            if (GenericHelper.isNullOrEmpty(deployBasePath)) {
                throw new IllegalArgumentException(" [Error] Deployment Base Path is either null or empty");
            }
            if (GenericHelper.isNullOrEmpty(versionName)) {
                throw new IllegalArgumentException(" [Error] Version Name is either null or empty");
            }
            if (GenericHelper.isNullOrEmpty(componentName)) {
                throw new IllegalArgumentException(" [Error] Component Name is either null or empty");
            }
            if (GenericHelper.isNullOrEmpty(resourceId)) {
                throw new IllegalArgumentException(" [Error] Resource Id is either null or empty");
            }
            File deployBasePathForVersion = new File(JDeploymentHelper.getVersionPathInDeployBasePath(deployBasePath, resourceId, componentName, versionName, true));
            if (deployBasePathForVersion.exists() && deployBasePathForVersion.isDirectory()) {
                if (!deployBasePathForVersion.canWrite()) {
                    throw new IllegalArgumentException(" [Error] User does not have WRITE permission to delete backup files from directory " + deployBasePathForVersion.getCanonicalPath());
                }
                Console.printActionTitle("Cleaning up backup files from " + deployBasePathForVersion.getCanonicalPath());
                if (!FileHelper.deleteDirectory(deployBasePathForVersion)) {
                    throw new IllegalArgumentException(" [Error] Failed to delete backup files from " + deployBasePathForVersion.getCanonicalPath());
                }
            } else {
                System.out.println(" [Warning] Directory " + deployBasePathForVersion.getCanonicalPath() + " does not exist. No cleanup action run for " + versionName);
            }
            System.out.println();
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }
}

