/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.GenericHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class JDeploymentHelper {
    public static void validateFileExist(String filePath, String errorInfo) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(errorInfo);
        }
    }

    public static String getStringInput(String input) {
        if (input != null) {
            input = input.trim();
        }
        return input;
    }

    public static boolean getBooleanInput(String input) {
        if (input != null) {
            input = input.trim();
        }
        return Boolean.parseBoolean(input);
    }

    public static void inputNotEmptyCheck(String input, String errorInformation) {
        if (null == input || input.length() == 0) {
            throw new IllegalArgumentException(errorInformation);
        }
    }

    public static String getVersionDirPathInWorkingDir(String basePath, String versionname, String resourceId) {
        return basePath + File.separator + resourceId + File.separator + versionname;
    }

    public static String getFilePathInWorkingDir(String basePath, String versionname, String resourceId, String fileName) {
        return JDeploymentHelper.getVersionDirPathInWorkingDir(basePath, versionname, resourceId) + File.separator + fileName;
    }

    public static String getVersionDirPathInRepository(String basePath, String componentName, String versionName) {
        return basePath + File.separator + componentName + File.separator + versionName;
    }

    public static String getFilePathInRepository(String basePath, String componentName, String versionName, String fileName) {
        return JDeploymentHelper.getVersionDirPathInRepository(basePath, componentName, versionName) + File.separator + fileName;
    }

    public static void cleanDir(String workdir) throws IOException {
        File versionWorkingDirectory = new File(workdir);
        if (versionWorkingDirectory.exists() && versionWorkingDirectory.isDirectory()) {
            FileUtils.deleteDirectory((File)versionWorkingDirectory);
        }
    }

    public static boolean directoryExist(String directoryPath) {
        File file = new File(directoryPath);
        return file.exists() && file.isDirectory();
    }

    public static String getVersionPathInDeployBasePath(String basePath, String resourceId, String componentName, String versionName, boolean compatible) {
        String basePathToVersion = basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName + File.separator + versionName;
        if (compatible && !JDeploymentHelper.directoryExist(basePathToVersion)) {
            basePathToVersion = basePath + File.separator + "deploy" + File.separator + componentName + File.separator + versionName;
        }
        return basePathToVersion;
    }

    public static String getComponentPathInDeployBasePath(String basePath, String resourceId, String componentName) {
        String basePathToComponent = GenericHelper.isNullOrEmpty(resourceId) ? basePath + File.separator + "deploy" + File.separator + componentName : basePath + File.separator + "deploy" + File.separator + resourceId + File.separator + componentName;
        return basePathToComponent;
    }
}

