/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PackageManifestParser {
    private static final String DELETED_TAG = "deleted";
    private static final String CONTAINER_TAG = "container";
    private static final String RESOURCE_TAG = "resource";
    private static final String PROPERTY_TAG = "property";
    private static final String INPUTS_TAG = "inputs";
    private static final String INPUT_TAG = "input";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String DEPLOY_TYPE_ATTRIBUTE = "deployType";
    private static final String CP037_ENCODING = "CP037";
    private static final String PROPERTY_TAG_NAME_ATTRIBUTE = "name";
    private static final String PROPERTY_TAG_VALUE_ATTRIBUTE = "value";
    private static final String INPUT_TAG_URL_ATTRIBUTE = "url";
    private static final String INPUT_TAG_NAME_ATTRIBUTE = "name";
    private static final String INPUT_TAG_VERSION_ATTRIBUTE = "version";
    private static final String INPUT_TAG_COMPILE_TYPE_ATTRIBUTE = "compileType";

    public static Set<DataSet> parseDeployedDatasets(InputStream rollbackInputStream) throws XMLStreamException {
        return PackageManifestParser.parseDeployedDatasets(rollbackInputStream, CP037_ENCODING);
    }

    public static Set<DataSet> parseDeployedDatasets(InputStream rollbackInputStream, String encoding) throws XMLStreamException {
        LinkedHashMap<String, DataSet> deployedDatasetMap = new LinkedHashMap<String, DataSet>();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4Dataset = inputFactory.createXMLEventReader(rollbackInputStream, encoding);
        DataSet currentDataset = null;
        String currentDataSetName = null;
        String currentDataSetDeployType = null;
        Member currentMember = null;
        boolean deleted = false;
        while (eventReader4Dataset.hasNext()) {
            String tagName;
            XMLEvent event = eventReader4Dataset.nextEvent();
            if (event.isStartElement()) {
                String propertyName;
                StartElement startElement = event.asStartElement();
                tagName = startElement.getName().getLocalPart().trim();
                if (tagName.equalsIgnoreCase(DELETED_TAG)) {
                    deleted = true;
                    continue;
                }
                if (tagName.equalsIgnoreCase(CONTAINER_TAG)) {
                    currentDataSetName = PackageManifestParser.getAttributeValue(startElement, "name");
                    String currentDataSetNameKey = deleted ? currentDataSetName + "_DELETE" : currentDataSetName;
                    currentDataSetDeployType = PackageManifestParser.getAttributeValue(startElement, DEPLOY_TYPE_ATTRIBUTE);
                    String currentDataSetType = PackageManifestParser.getAttributeValue(startElement, TYPE_ATTRIBUTE);
                    if (deployedDatasetMap.containsKey(currentDataSetNameKey)) {
                        currentDataset = (DataSet)deployedDatasetMap.get(currentDataSetNameKey);
                        continue;
                    }
                    currentDataset = new DataSet();
                    currentDataset.setType(currentDataSetType);
                    currentDataset.setDeployType(currentDataSetDeployType);
                    currentDataset.setName(currentDataSetName);
                    currentDataset.setSrcDataSetName(currentDataSetName);
                    currentDataset.setDelete(deleted);
                    deployedDatasetMap.put(currentDataSetNameKey, currentDataset);
                    continue;
                }
                if (tagName.equalsIgnoreCase(RESOURCE_TAG)) {
                    if (null == currentDataset || null == currentDataSetName) continue;
                    String memberName = PackageManifestParser.getAttributeValue(startElement, "name");
                    String memberType = PackageManifestParser.getAttributeValue(startElement, TYPE_ATTRIBUTE);
                    String memberDeployType = PackageManifestParser.getAttributeValue(startElement, DEPLOY_TYPE_ATTRIBUTE);
                    if (null == memberDeployType || memberDeployType.length() == 0) {
                        memberDeployType = currentDataSetDeployType;
                    }
                    Member dsMember = new Member();
                    dsMember.setName(memberName);
                    dsMember.setType(memberType);
                    dsMember.setDataSetName(currentDataSetName);
                    dsMember.setSrcDataSetName(currentDataSetName);
                    dsMember.setDeployType(memberDeployType);
                    currentMember = dsMember;
                    currentDataset.addMember(dsMember);
                    continue;
                }
                if (tagName.equalsIgnoreCase(PROPERTY_TAG)) {
                    propertyName = PackageManifestParser.getAttributeValue(startElement, "name");
                    String propertyValue = PackageManifestParser.getAttributeValue(startElement, PROPERTY_TAG_VALUE_ATTRIBUTE);
                    if (null == propertyName || propertyName.length() <= 0) continue;
                    if (null == propertyValue) {
                        propertyValue = "";
                    }
                    if (null != currentMember) {
                        currentMember.addCustomerProperty(propertyName, propertyValue);
                        continue;
                    }
                    if (null == currentDataset) continue;
                    currentDataset.addCustomerProperty(propertyName, propertyValue);
                    continue;
                }
                if (tagName.equalsIgnoreCase(INPUTS_TAG)) {
                    String propertyUrl = PackageManifestParser.getAttributeValue(startElement, INPUT_TAG_URL_ATTRIBUTE);
                    if (null == currentMember) continue;
                    currentMember.getInputs().setUrl(propertyUrl);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(INPUT_TAG)) continue;
                propertyName = PackageManifestParser.getAttributeValue(startElement, "name");
                String propertyVersion = PackageManifestParser.getAttributeValue(startElement, INPUT_TAG_VERSION_ATTRIBUTE);
                String propertyUrl = PackageManifestParser.getAttributeValue(startElement, INPUT_TAG_URL_ATTRIBUTE);
                String propertyCompileType = PackageManifestParser.getAttributeValue(startElement, INPUT_TAG_COMPILE_TYPE_ATTRIBUTE);
                if (null == currentMember) continue;
                currentMember.getInputs().addInput(propertyName, propertyVersion, propertyUrl, propertyCompileType);
                continue;
            }
            if (!event.isEndElement()) continue;
            EndElement endElement = event.asEndElement();
            tagName = endElement.getName().getLocalPart().trim();
            if (tagName.equalsIgnoreCase(DELETED_TAG)) {
                deleted = false;
                continue;
            }
            if (tagName.equalsIgnoreCase(CONTAINER_TAG)) {
                currentDataset = null;
                currentDataSetName = null;
                currentDataSetDeployType = null;
                continue;
            }
            if (!tagName.equalsIgnoreCase(RESOURCE_TAG)) continue;
            currentMember = null;
        }
        return new LinkedHashSet<DataSet>(deployedDatasetMap.values());
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        String attributeValue = null;
        QName qName = new QName(attributeName);
        Attribute attribute = startElement.getAttributeByName(qName);
        if (null != attribute) {
            attributeValue = attribute.getValue().trim();
        }
        return attributeValue;
    }
}

