/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.enterprise.deployment.hfs.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BackupFilesTask
extends Task {
    private File manifestFile;
    private File outputDir;
    private String outputFile;
    private File containerMapperHfsFile;
    private boolean oldVersionIdentifier;

    public void execute() throws BuildException {
        if (this.manifestFile != null && this.manifestFile.exists()) {
            try {
                String HFStargetOutputsDir;
                File targetOutputsDirPathFile;
                PrintWriter includesFileOutput;
                File includesFile;
                boolean addedIncludes;
                String targetOutputsDirPath;
                File targetOutputsDir;
                String containerName;
                int containerIndex;
                Manifest deltaManifest;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(this.containerMapperHfsFile);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("map");
                ArrayList<String> sourceList = new ArrayList<String>();
                ArrayList<String> targetList = new ArrayList<String>();
                for (int temp = 0; temp < nList.getLength(); ++temp) {
                    Element element;
                    Node node1;
                    int count;
                    Node nNode = nList.item(temp);
                    if (nNode.getNodeType() != 1) continue;
                    Element eElement = (Element)nNode;
                    NodeList sourceContainerList = eElement.getElementsByTagName("sourceContainer");
                    NodeList targetContainerList = eElement.getElementsByTagName("targetContainer");
                    for (count = 0; count < sourceContainerList.getLength(); ++count) {
                        node1 = sourceContainerList.item(count);
                        if (node1.getNodeType() != 1) continue;
                        element = (Element)node1;
                        sourceList.add(element.getAttribute("name"));
                    }
                    for (count = 0; count < targetContainerList.getLength(); ++count) {
                        node1 = targetContainerList.item(count);
                        if (node1.getNodeType() != 1) continue;
                        element = (Element)node1;
                        targetList.add(element.getAttribute("name"));
                    }
                }
                Manifest packageManifest = ManifestReader.getInstance().getManifest(this.manifestFile);
                String manifestDir = this.manifestFile.getParent();
                File deltaManifestFile = new File(manifestDir + File.separator + "deltaDeployed.xml");
                if (deltaManifestFile.exists()) {
                    deltaManifest = ManifestReader.getInstance().getManifest(deltaManifestFile);
                } else {
                    deltaManifest = new Manifest();
                    deltaManifest.setType("MANIFEST_REPORT");
                }
                List createOrUpdateContainers = HFSUtil.getHFSContainers((List)packageManifest.getContainers());
                List deletedContainers = HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers());
                if (createOrUpdateContainers.size() == 0 && deletedContainers.size() == 0) {
                    throw new Exception(" [Error] No create/update or delete containers found in package manifest.");
                }
                for (Container container : createOrUpdateContainers) {
                    ArrayList<Container> createOrUpdateContainersList = new ArrayList<Container>();
                    containerIndex = 0;
                    containerName = File.separator + container.getName();
                    if (!sourceList.contains(containerName)) {
                        throw new Exception(" [Error] SourceList does not contain container name " + containerName);
                    }
                    containerIndex = sourceList.indexOf(containerName);
                    createOrUpdateContainersList.add(container);
                    targetOutputsDir = new File((String)targetList.get(containerIndex));
                    targetOutputsDirPath = this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + containerName : targetOutputsDir.getCanonicalPath();
                    addedIncludes = false;
                    includesFile = new File(manifestDir + File.separator + "deltaDeployed.asHFSFileSet");
                    includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(includesFile), "UTF-8")));
                    if (this.processFilesToCreateOrUpdate(container, targetOutputsDirPath, includesFileOutput, deltaManifest)) {
                        addedIncludes = true;
                    }
                    includesFileOutput.flush();
                    includesFileOutput.close();
                    if (addedIncludes) {
                        targetOutputsDirPathFile = new File(targetOutputsDirPath);
                        FileSet updatesFileSet = new FileSet();
                        updatesFileSet.setProject(this.getProject());
                        updatesFileSet.setDir(targetOutputsDirPathFile);
                        updatesFileSet.setIncludesfile(includesFile);
                        HFStargetOutputsDir = "HFS" + File.separator + container.getName();
                        HFSUtil.createTar(Arrays.asList(updatesFileSet), (File)new File(this.outputDir, this.outputFile), (String)HFStargetOutputsDir, (Project)this.getProject());
                    }
                    includesFile.delete();
                    HFSUtil.serializeManifest((Manifest)deltaManifest, (File)deltaManifestFile);
                }
                for (Container container : deletedContainers) {
                    ArrayList<Container> deletedContainersList = new ArrayList<Container>();
                    containerIndex = 0;
                    containerName = File.separator + container.getName();
                    if (!sourceList.contains(containerName)) {
                        throw new Exception(" [Error] SourceList does not contain container name " + containerName);
                    }
                    containerIndex = sourceList.indexOf(containerName);
                    deletedContainersList.add(container);
                    targetOutputsDir = new File((String)targetList.get(containerIndex));
                    targetOutputsDirPath = this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + containerName : targetOutputsDir.getCanonicalPath();
                    addedIncludes = false;
                    includesFile = new File(manifestDir + File.separator + "deltaDeployed.asHFSFileSet");
                    includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(includesFile))));
                    if (this.processDeltaManifestForDeletes(container, targetOutputsDirPath, includesFileOutput, deltaManifest, packageManifest, this.getProject())) {
                        addedIncludes = true;
                    }
                    includesFileOutput.flush();
                    includesFileOutput.close();
                    if (addedIncludes) {
                        targetOutputsDirPathFile = new File(targetOutputsDirPath);
                        FileSet deletesFileSet = new FileSet();
                        deletesFileSet.setProject(this.getProject());
                        deletesFileSet.setDir(targetOutputsDirPathFile);
                        deletesFileSet.setIncludesfile(includesFile);
                        HFStargetOutputsDir = "HFS" + File.separator + container.getName();
                        HFSUtil.createTar(Arrays.asList(deletesFileSet), (File)new File(this.outputDir, this.outputFile), (String)HFStargetOutputsDir, (Project)this.getProject());
                    }
                    includesFile.delete();
                    HFSUtil.serializeManifest((Manifest)deltaManifest, (File)deltaManifestFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
        } else {
            throw new BuildException(NLS.bind((String)Messages.BackupFilesTask_PACKAGE_MANIFEST_NOT_FOUND_ERROR_MSG, (Object)(this.manifestFile == null ? "" : this.manifestFile.getAbsolutePath())));
        }
    }

    private boolean processDeltaManifestForDeletes(Container container, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest, Manifest packageManifest, Project project) {
        HashMap<String, Container> deltaContainerMapping = new HashMap<String, Container>();
        for (Container deltaContainer : HFSUtil.getHFSContainers((List)deltaManifest.getDeletedContainers(), (boolean)true)) {
            deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
        }
        boolean addedIncludes = false;
        Iterator resources = container.getResourcesIterator();
        ArrayList<String> deletedFiles = new ArrayList<String>();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String relativePath = resource.getName();
            FileSet fileSet = new FileSet();
            fileSet.setProject(project);
            fileSet.setDir(new File(outputsDirPath));
            fileSet.createInclude().setName(relativePath);
            HashMap<String, HashSet<Resource>> directoryToResourceMapping = new HashMap<String, HashSet<Resource>>();
            BackupFilesTask.scanFiles(fileSet, outputsDirPath, directoryToResourceMapping, project, resource);
            if (directoryToResourceMapping.size() <= 0) continue;
            Set<String> containerNames = directoryToResourceMapping.keySet();
            for (String containerName : containerNames) {
                Container deltaContainer;
                if (!containerName.equals(outputsDirPath)) continue;
                String deltaContainerName = container.getName();
                boolean isNewContainer = false;
                if (!deltaContainerMapping.containsKey(deltaContainerName)) {
                    isNewContainer = true;
                    deltaContainer = new Container();
                    deltaContainer.setType("directory");
                    deltaContainer.setChangeType("DELETE");
                    deltaContainer.setName(deltaContainerName);
                } else {
                    deltaContainer = (Container)deltaContainerMapping.get(deltaContainerName);
                }
                for (Resource newResource : directoryToResourceMapping.get(containerName)) {
                    deltaContainer.addResource(newResource);
                    String includePath = newResource.getName();
                    deletedFiles.add(container.getName() + File.separator + includePath);
                    includesFileOutput.println(includePath);
                    addedIncludes = true;
                }
                if (!isNewContainer || !deltaContainer.getResourcesIterator().hasNext()) continue;
                deltaManifest.addDeletedContainer(deltaContainer);
                deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
            }
        }
        boolean isNewContainer = false;
        Container deltaContainer = (Container)deltaContainerMapping.get(container.getName());
        if (deltaContainer == null) {
            isNewContainer = true;
            deltaContainer = new Container();
            deltaContainer.setType("directory");
            deltaContainer.setChangeType("DELETE");
            deltaContainer.setName(container.getName());
        }
        Iterator pkgResources = container.getResourcesIterator();
        while (pkgResources.hasNext()) {
            String path;
            Resource pkgResource = (Resource)pkgResources.next();
            if (pkgResource.getName().contains("*") || pkgResource.getName().contains("?") || deletedFiles.contains(path = HFSUtil.getNormalizedPath((Container)container, (Resource)pkgResource))) continue;
            Resource newResource = new Resource(pkgResource);
            newResource.setMissing("true");
            deltaContainer.addResource(newResource);
        }
        if (isNewContainer && deltaContainer.getResourcesIterator().hasNext()) {
            deltaManifest.addDeletedContainer(deltaContainer);
            deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
        }
        return addedIncludes;
    }

    private boolean processFilesToCreateOrUpdate(Container container, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest) {
        boolean addedIncludes = false;
        HashMap<String, Container> createdContainers = new HashMap<String, Container>();
        HashMap<String, Container> updatedContainers = new HashMap<String, Container>();
        Iterator resources = container.getResourcesIterator();
        while (resources.hasNext()) {
            Container newContainer;
            Resource resource = (Resource)resources.next();
            String relativePath = resource.getName();
            File file = new File(outputsDirPath + File.separator + relativePath);
            if (file.exists()) {
                newContainer = (Container)updatedContainers.get(container.getName());
                if (newContainer == null) {
                    newContainer = new Container();
                    newContainer.setName(container.getName());
                    newContainer.setType("directory");
                    newContainer.setChangeType("UPDATE");
                    updatedContainers.put(newContainer.getName(), newContainer);
                }
                includesFileOutput.println(relativePath);
                addedIncludes = true;
            } else {
                newContainer = (Container)createdContainers.get(container.getName());
                if (newContainer == null) {
                    newContainer = new Container();
                    newContainer.setName(container.getName());
                    newContainer.setType("directory");
                    newContainer.setChangeType("ADD");
                    createdContainers.put(newContainer.getName(), newContainer);
                }
            }
            Resource newResource = new Resource(resource);
            newContainer.addResource(newResource);
        }
        deltaManifest.getCreatedContainers().addAll(createdContainers.values());
        deltaManifest.getUpdatedContainers().addAll(updatedContainers.values());
        return addedIncludes;
    }

    public static void scanFiles(FileSet fileSet, String outputsDirPath, HashMap<String, HashSet<Resource>> directoryToResourceMapping, Project project, Resource originalResource) {
        String[] resolvedFiles;
        DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
        for (String resolvedFile : resolvedFiles = scanner.getIncludedFiles()) {
            int lastIndexOfSlash = resolvedFile.lastIndexOf(File.separator);
            if (lastIndexOfSlash != -1) {
                HFSUtil.collectFileInformation((String)(outputsDirPath + File.separator + resolvedFile.substring(0, lastIndexOfSlash)), (String)resolvedFile.substring(lastIndexOfSlash + 1), null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
                continue;
            }
            HFSUtil.collectFileInformation((String)outputsDirPath, (String)resolvedFile, null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
        }
    }

    public void setManifest(File manifest) {
        this.manifestFile = manifest;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public File getcontainerMapperHfsFile() {
        return this.containerMapperHfsFile;
    }

    public void setcontainerMapperHfsFile(File containerMapperHfsFile) {
        this.containerMapperHfsFile = containerMapperHfsFile;
    }

    public boolean isoldVersionIdentifier() {
        return this.oldVersionIdentifier;
    }

    public void setoldVersionIdentifier(boolean oldVersionIdentifier) {
        this.oldVersionIdentifier = oldVersionIdentifier;
    }
}

