/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;

public class AllocateDatasetSms {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            String datasetName;
            String zFileDsn;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("datasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(inputProperties.getProperty("deleteDataset"));
            String managementClass = inputProperties.getProperty("managementClass").trim();
            String storageClass = inputProperties.getProperty("storageClass").trim();
            String dataClass = inputProperties.getProperty("dataClass");
            if (GenericHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                System.exit(1);
            }
            if (ZFile.dsExists((String)(zFileDsn = ZFile.getSlashSlashQuotedDSN((String)(datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName)), (boolean)true)))) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    System.exit(1);
                }
            }
            if (GenericHelper.isNullOrEmpty(managementClass) && GenericHelper.isNullOrEmpty(storageClass) && GenericHelper.isNullOrEmpty(dataClass)) {
                System.out.println(" [Error] At least one class needs to be specified.");
                System.exit(1);
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!GenericHelper.isNullOrEmpty(managementClass)) {
                allocCommand = allocCommand + " MGMTCLAS(" + managementClass + ")";
            }
            if (!GenericHelper.isNullOrEmpty(storageClass)) {
                allocCommand = allocCommand + " STORCLAS(" + storageClass + ")";
            }
            if (!GenericHelper.isNullOrEmpty(dataClass)) {
                allocCommand = allocCommand + " DATACLAS(" + dataClass + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Command: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                datasetName = MVSHelper.getGDGActualName(ddName);
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                apTool.setOutputProperty("DatasetName", datasetName);
                apTool.storeOutputProperties();
                System.exit(0);
            } else {
                System.out.println(" [Error] Failed to create dataset " + datasetName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

