/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.Buzdepv2Executor;
import com.ibm.urbancode.zos.common.util.DeleteActionRecordsLoader;
import com.ibm.urbancode.zos.common.util.ProcessExecutor;
import com.ibm.urbancode.zos.dataset.util.ActionDatasetBuilder;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.urbancode.air.plugin.inputs.DeleteDatasetInput;
import java.util.Properties;

public class DeleteDataset {
    private int exitCode = 0;
    private final Properties inputProperties;

    public DeleteDataset(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute() {
        block8: {
            String tempActionDsn = null;
            try {
                DeleteDatasetInput pluginInput = new DeleteDatasetInput(this.inputProperties);
                pluginInput.validateInputs();
                DeleteActionRecordsLoader deleteActionRecordsLoader = new DeleteActionRecordsLoader(pluginInput);
                deleteActionRecordsLoader.load();
                tempActionDsn = TempDsnNameHelper.getActionDsnName(pluginInput.getDsnPrefix());
                ActionDatasetBuilder actionDatasetBuilder = new ActionDatasetBuilder(deleteActionRecordsLoader.getActionRecords(), tempActionDsn);
                actionDatasetBuilder.build();
                Buzdepv2Executor buzdepv2Executor = new Buzdepv2Executor(tempActionDsn, pluginInput.getDsnPrefix(), pluginInput.getIspfGatewayBinariesPath());
                ProcessExecutor processExecutor = buzdepv2Executor.execute();
                this.exitCode = processExecutor.getExitCode();
                if (this.exitCode != 0) {
                    System.out.println("Error executing process with arguments " + processExecutor.getProcessArguments());
                }
                System.out.print(processExecutor.getProcessOutput());
                this.deleteDataset(tempActionDsn);
            }
            catch (RuntimeException runtimeException) {
                this.handleRuntimeExceptions(runtimeException);
                this.exitCode = 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.exitCode = 1;
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.deleteDataset(tempActionDsn);
            }
        }
        return this.exitCode;
    }

    private void handleRuntimeExceptions(Exception exception) {
        if (exception instanceof RcException) {
            exception.printStackTrace();
        } else {
            System.out.println(" [Error] " + exception.getMessage());
        }
    }

    private void deleteDataset(String dataset) {
        try {
            DatasetHelper.deleteDataset(dataset);
        }
        catch (ZFileException e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
    }
}

