/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.urbancode.air.plugin.inputs.InvalidInputException;

public class VersionTypeValidator {
    private final String versionType;

    public VersionTypeValidator(String versionType) {
        this.versionType = versionType;
    }

    public void validate() {
        if (this.versionTypeIsNotFull() && this.versionTypeIsNotIncremental()) {
            throw new InvalidInputException("Invalid version type - " + this.versionType + ". Version Type must be either " + "FULL" + " or " + "INCREMENTAL");
        }
    }

    private boolean versionTypeIsNotIncremental() {
        return !this.versionType.equalsIgnoreCase("INCREMENTAL");
    }

    private boolean versionTypeIsNotFull() {
        return !this.versionType.equalsIgnoreCase("FULL");
    }
}

