/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.IspfGatewayXMLOutputHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TSOHelper {
    private String ispfGatewayPath;
    private boolean reuseSession;
    private String serviceType;
    private String ispProf;
    private String outputText;
    private int returnCode;
    private String reasonCode;
    private String operationsLog;
    private static final String CLISTERRORTEXT = "The initially invoked CLIST ended with a return code = ";
    private static final int ERR_CODE = 1;
    private boolean debug = false;

    public TSOHelper(String ispfGatewayPath, boolean reuseSession, String serviceType, String ispProf) {
        this.ispfGatewayPath = ispfGatewayPath;
        this.reuseSession = reuseSession;
        this.serviceType = serviceType;
        this.ispProf = ispProf;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getOperationsLog() {
        return this.operationsLog;
    }

    public void turnDebugOn() {
        this.debug = true;
    }

    public int runCommand(String tsoCommand) {
        String ispfzxml = this.ispfGatewayPath + File.separator + "ISPZXML";
        this.debug(ispfzxml);
        File ispfzxmlFile = new File(ispfzxml);
        if (!ispfzxmlFile.exists()) {
            System.out.println(" [ERROR] ISPZXML file does not exist in ISPF gateway path " + this.ispfGatewayPath);
            System.exit(1);
        }
        if (!ispfzxmlFile.canExecute() || !ispfzxmlFile.canRead()) {
            System.out.println(" [ERROR] ISPZXML file does not have Execute and Read permission in ISPF gateway path " + this.ispfGatewayPath);
            System.exit(1);
        }
        if (!this.serviceType.equals("ISPF")) {
            this.serviceType = "TSO";
        }
        this.outputText = "";
        this.operationsLog = "";
        this.returnCode = 0;
        this.reasonCode = "";
        StringBuilder inputXMLWriter = new StringBuilder();
        inputXMLWriter.append("<?xml version=\"1.0\"?>\n");
        inputXMLWriter.append("<ISPF-INPUT>\n");
        inputXMLWriter.append("<SERVICE-REQUEST>\n");
        inputXMLWriter.append("<service>" + this.serviceType + "</service>\n");
        inputXMLWriter.append("<session>" + (this.reuseSession ? "REUSE" : "NONE") + "</session>\n");
        inputXMLWriter.append("<command>" + tsoCommand + "</command>\n");
        if (this.serviceType.equals("ISPF")) {
            inputXMLWriter.append("<ispprof>" + this.ispProf + "</ispprof>\n");
        }
        inputXMLWriter.append("</SERVICE-REQUEST>\n");
        inputXMLWriter.append("</ISPF-INPUT>\n");
        this.debug("===============================");
        this.debug("request XML");
        this.debug(inputXMLWriter.toString());
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(ispfzxml);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        processBuilder.environment().put("PATH", System.getenv("PATH") + ":" + this.ispfGatewayPath);
        Process process = null;
        try {
            process = processBuilder.start();
            PrintWriter processInput = new PrintWriter(new OutputStreamWriter(process.getOutputStream()));
            processInput.println(inputXMLWriter);
            processInput.flush();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            StringBuffer outputXMLString = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith("Connection Protocol")) continue;
                outputXMLString.append(line).append('\n');
            }
            process.waitFor();
            String xmlContent = outputXMLString.toString();
            int xmlpos = xmlContent.indexOf("<?xml version");
            if (xmlpos == -1) {
                throw new Exception("Failed to get response XML from ISPF Gateway.");
            }
            xmlContent = xmlContent.substring(xmlpos);
            this.debug("===============================");
            this.debug("response XML");
            this.debug(xmlContent);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            IspfGatewayXMLOutputHandler xmlHandler = new IspfGatewayXMLOutputHandler();
            saxParser.parse(new InputSource(new StringReader(xmlContent.toString())), (DefaultHandler)xmlHandler);
            this.operationsLog = xmlHandler.getOperationsLog();
            if (this.serviceType.equals("TSO")) {
                this.outputText = xmlHandler.getOutputText();
            } else if (this.serviceType.equals("ISPF")) {
                this.outputText = xmlHandler.getOutputText();
                this.returnCode = Integer.valueOf(xmlHandler.getReturnCode());
                if (this.returnCode > 0) {
                    this.reasonCode = "";
                    List<String> reasonCodeList = xmlHandler.getReasonCodeList();
                    for (int i = 0; i < reasonCodeList.size(); ++i) {
                        this.reasonCode = this.reasonCode + reasonCodeList.get(i) + "\n";
                    }
                } else {
                    int pos = this.outputText.indexOf(CLISTERRORTEXT);
                    if (pos > 0) {
                        String trimmedOutputText = this.outputText.substring(pos + CLISTERRORTEXT.length()).trim();
                        String[] trimmedOutputTextArray = trimmedOutputText.split("\n");
                        this.returnCode = Integer.parseInt(trimmedOutputTextArray[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return process.exitValue();
    }

    private void debug(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }
}

