/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import java.util.ArrayList;

public class CatalogSearchField {
    String name;
    byte[] bytes;
    int length;
    int lengthFieldLength = 2;

    CatalogSearchField(String name, byte[] workAreaBytes, int offset, int length, int lengthFieldLength) {
        this.length = length;
        this.name = name;
        this.bytes = new byte[length >= 0 ? length : 0];
        if (length > 0) {
            System.arraycopy(workAreaBytes, offset, this.bytes, 0, length);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public char getChar() {
        if (this.length != 1) {
            throw new IllegalStateException("Field length must be 1 to construct a char.");
        }
        return ByteUtil.bytesAsString(this.bytes, 0, 1, "IBM-1047").charAt(0);
    }

    public String getFString() {
        if (this.length <= 0) {
            return null;
        }
        return ByteUtil.bytesAsString(this.bytes, 0, this.bytes.length, "IBM-1047");
    }

    public int getInt() {
        if (this.length < 1 || this.length > 4) {
            throw new IllegalStateException("Field length must be between 1 and 4 bytes, but is " + this.length);
        }
        return ByteUtil.bytesAsInt(this.bytes);
    }

    public int[] getIntArray(int len) {
        if (len < 1 || len > 4) {
            throw new IllegalStateException("Field length must be between 1 and 4 bytes, but is " + this.length);
        }
        if (this.length <= 0) {
            return null;
        }
        if (this.length % len != 0) {
            throw new IllegalStateException("Fixed length field data not a multiple of " + len);
        }
        int numFields = this.length / len;
        int[] array = new int[numFields];
        for (int i = 0; i < numFields; ++i) {
            array[i] = ByteUtil.bytesAsInt(this.bytes, i * len, len);
        }
        return array;
    }

    public String[] getFStringArray(int len) {
        if (this.length <= 0) {
            return null;
        }
        if (this.length % len != 0) {
            throw new IllegalStateException("Fixed length field data not a multiple of " + len);
        }
        int numFields = this.length / len;
        String[] array = new String[numFields];
        for (int i = 0; i < numFields; ++i) {
            array[i] = ByteUtil.bytesAsString(this.bytes, i * len, len, "IBM-1047");
        }
        return array;
    }

    public String[] getVStringArray() {
        int l;
        if (this.length <= 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int pos = 0; pos < this.bytes.length; pos += l) {
            l = ByteUtil.bytesAsInt(this.bytes, pos, this.lengthFieldLength);
            list.add(ByteUtil.bytesAsString(this.bytes, pos += this.lengthFieldLength, l, "IBM-1047"));
        }
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public String getVString() {
        if (this.length <= 0) {
            return null;
        }
        return ByteUtil.bytesAsString(this.bytes, this.lengthFieldLength, this.bytes.length - this.lengthFieldLength, "IBM-1047");
    }

    public boolean isFixedMissing() {
        if (this.bytes.length == 0) {
            return false;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == 255) continue;
            return false;
        }
        return true;
    }

    public boolean isSuppressed() {
        return this.length == -1;
    }
}

