/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.SystemEnv;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.RexxFileToDatasetConvertor;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Buzdepv2Executor {
    private final String actionDsn;
    private final String dsnPrefix;
    private final String ispfGatewayBinariesPath;

    public Buzdepv2Executor(String actionDsn, String dsnPrefix, String ispfGatewayBinariesPath) {
        this.actionDsn = actionDsn;
        this.dsnPrefix = dsnPrefix;
        this.ispfGatewayBinariesPath = ispfGatewayBinariesPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessExecutor execute() throws Exception {
        ProcessExecutor processExecutor;
        String rexxDataset = TempDsnNameHelper.getRexxDsnName(this.dsnPrefix);
        try {
            this.copyRexxProgramToDataset(rexxDataset);
            List<String> processArguments = this.buildIspfProcessArguments(rexxDataset);
            Map<String, String> envVariables = this.buildEnvVariables();
            processExecutor = new ProcessExecutor(this.getProcessBuilder(processArguments, envVariables));
            processExecutor.execute();
        }
        finally {
            DatasetHelper.deleteDataset(rexxDataset);
        }
        return processExecutor;
    }

    private ProcessBuilder getProcessBuilder(List<String> ispfGatewayArguments, Map<String, String> environmentVariables) {
        String[] commandArguments = ispfGatewayArguments.toArray(new String[0]);
        ProcessBuilder processBuilder = new ProcessBuilder(commandArguments);
        Map<String, String> env = processBuilder.environment();
        env.putAll(environmentVariables);
        return processBuilder;
    }

    private Map<String, String> buildEnvVariables() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ISPF_LOG_DIR", SystemEnv.getBuzToolkitHome() + "/var/log/ispf");
        env.put("PATH", SystemEnv.getBuzToolkitHome() + "/conf/toolkit" + File.pathSeparator + this.ispfGatewayBinariesPath + File.pathSeparator + this.getCurrentEnvPath());
        env.put("CGI_ISPPREF", this.dsnPrefix);
        return env;
    }

    private String getCurrentEnvPath() {
        return System.getenv("PATH") == null ? "" : System.getenv("PATH");
    }

    private void copyRexxProgramToDataset(String rexxDataset) throws IOException {
        String rexxFilePath = SystemEnv.getPluginHome() + File.separator + "BUZDEPV2.rexx";
        new RexxFileToDatasetConvertor(rexxFilePath, rexxDataset).convert();
    }

    private List<String> buildIspfProcessArguments(String tempRexxDataset) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getStartIspfScriptPath());
        arguments.add(tempRexxDataset);
        arguments.add("BUZDEPV2");
        arguments.add(this.actionDsn);
        return arguments;
    }

    private String getStartIspfScriptPath() {
        return SystemEnv.getPluginHome() + File.separator + "startispf_tso.sh";
    }
}

