/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.util.Properties;

public class AllocateDataset {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            String datasetName;
            String zFileDsn;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String indatasetName = inputProperties.getProperty("dataSetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(inputProperties.getProperty("deleteDataset"));
            String volumeSerial = inputProperties.getProperty("volumeSerial").trim();
            int primaryQuantity = Integer.parseInt(inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(inputProperties.getProperty("secondaryQuantity").trim());
            int directoryBlocks = Integer.parseInt(inputProperties.getProperty("directoryBlocks").trim().isEmpty() ? "0" : inputProperties.getProperty("directoryBlocks").trim());
            int recordLength = Integer.parseInt(inputProperties.getProperty("recordLength").trim());
            int blockSize = Integer.parseInt(inputProperties.getProperty("blockSize").trim());
            String spaceUnit = inputProperties.getProperty("spaceUnit");
            String averageRECUnit = inputProperties.getProperty("averRecUnit");
            String recordFormat = inputProperties.getProperty("recordFormat");
            String dataSetNameType = inputProperties.getProperty("dataSetNameType");
            if (GenericHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Dataset Name can not be empty.");
                System.exit(1);
            }
            if (ZFile.dsExists((String)(zFileDsn = ZFile.getSlashSlashQuotedDSN((String)(datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName)), (boolean)true)))) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    System.exit(1);
                }
            }
            if (primaryQuantity < 0 || secondaryQuantity < 0) {
                System.out.println(" [Error] Primary or Secondary Quantity must be a positive integer.");
                System.exit(1);
            }
            if (recordLength < 0) {
                System.out.println(" [Error] Record length must be a positive integer.");
                System.exit(1);
            }
            if (blockSize < 0) {
                System.out.println(" [Error] Block size must be a positive integer.");
                System.exit(1);
            }
            if (directoryBlocks < 0) {
                System.out.println(" [Error] Directory blocks must be a positive integer.");
                System.exit(1);
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!GenericHelper.isNullOrEmpty(volumeSerial)) {
                allocCommand = allocCommand + " vol(" + volumeSerial + ")";
            }
            allocCommand = allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
            allocCommand = spaceUnit.equals("BLKS") ? allocCommand + " block(" + recordLength + ")" : allocCommand + " " + spaceUnit;
            if (blockSize > 0) {
                allocCommand = allocCommand + " blksize(" + blockSize + ")";
            }
            if (!averageRECUnit.equals("---")) {
                allocCommand = allocCommand + " avgrec(" + averageRECUnit + ")";
            }
            allocCommand = allocCommand + " dir(" + directoryBlocks + ") recfm(" + recordFormat + ")";
            if (!spaceUnit.equals("BLKS") || !recordFormat.equals("U")) {
                allocCommand = allocCommand + " lrecl(" + recordLength + ")";
            }
            if (!dataSetNameType.equals("---")) {
                allocCommand = allocCommand + " dsntype(" + dataSetNameType + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Command: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                datasetName = MVSHelper.getGDGActualName(ddName);
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                apTool.setOutputProperty("DatasetName", datasetName);
                apTool.storeOutputProperties();
                System.exit(0);
            } else {
                System.out.println(" [Error] Failed to create dataset " + datasetName);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

