/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.packaging.common.extrepo;

import com.ibm.urbancode.zos.packaging.common.extrepo.ExternalRepoInputs;
import com.ibm.urbancode.zos.packaging.common.extrepo.ExternalRepoType;
import com.ibm.urbancode.zos.packaging.common.extrepo.ExternalRepoTypeValidator;
import com.ibm.urbancode.zos.packaging.common.extrepo.MissingExternalRepoInputException;

public class ExternalRepoInputsValidator {
    private final String extRepoUsername;
    private final String extRepoPassword;
    private final String extRepoUrl;
    private final String extRepoRawDirectory;
    private final String extRepoRepositoryName;
    private final String extRepoRepositoryType;

    public ExternalRepoInputsValidator(ExternalRepoInputs externalRepoInputs) {
        this.extRepoUsername = externalRepoInputs.getUsername();
        this.extRepoUrl = externalRepoInputs.getUrl();
        this.extRepoRepositoryType = externalRepoInputs.getRepositoryType();
        this.extRepoPassword = externalRepoInputs.getPassword();
        this.extRepoRepositoryName = externalRepoInputs.getRepositoryName();
        this.extRepoRawDirectory = externalRepoInputs.getRawDirectory();
    }

    public void validate() {
        this.validateRepositoryType();
        this.validateUrl();
        this.validateUserName();
        this.validatePassword();
        this.validateRepoName();
        this.validateRawDirectory();
    }

    private void validateRepositoryType() {
        if (this.extRepoRepositoryType == null) {
            throw new MissingExternalRepoInputException("External repository type is a mandatory input. Artifactory (or) Nexus are valid values ");
        }
        ExternalRepoTypeValidator.validate("External Repository Type", this.extRepoRepositoryType);
    }

    private void validateUrl() {
        if (this.extRepoUrl == null) {
            throw new MissingExternalRepoInputException("Url is a mandatory input for external repository");
        }
    }

    private void validateUserName() {
        if (this.extRepoUsername == null) {
            throw new MissingExternalRepoInputException("Username is a mandatory input for external repository");
        }
    }

    private void validatePassword() {
        if (this.extRepoPassword == null) {
            if (this.extRepoRepositoryType.equals(ExternalRepoType.ARTIFACTORY.getValue())) {
                throw new MissingExternalRepoInputException("Password (or) APIKey is a mandatory input for " + this.extRepoRepositoryType);
            }
            throw new MissingExternalRepoInputException("Password is a mandatory input for " + this.extRepoRepositoryType);
        }
    }

    private void validateRepoName() {
        if (this.extRepoRepositoryName == null) {
            throw new MissingExternalRepoInputException("Repository name/path is a mandatory input for external repository");
        }
    }

    private void validateRawDirectory() {
        if (this.isRawDirectoryNotPassedForNexus()) {
            throw new MissingExternalRepoInputException("\"Raw directory\" is a mandatory input for storing artifacts in Nexus");
        }
    }

    private boolean isRawDirectoryNotPassedForNexus() {
        return this.extRepoRepositoryType.equals(ExternalRepoType.NEXUS.getValue()) && this.extRepoRawDirectory == null;
    }
}

