/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.MVSHelper;
import java.util.Properties;

public class AllocateDatasetSms {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public AllocateDatasetSms(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            String indatasetName = this.inputProperties.getProperty("datasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(this.inputProperties.getProperty("deleteDataset"));
            String managementClass = this.inputProperties.getProperty("managementClass").trim();
            String storageClass = this.inputProperties.getProperty("storageClass").trim();
            String dataClass = this.inputProperties.getProperty("dataClass");
            if (GenericHelper.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                return 1;
            }
            String datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    return 1;
                }
            }
            if (GenericHelper.isNullOrEmpty(managementClass) && GenericHelper.isNullOrEmpty(storageClass) && GenericHelper.isNullOrEmpty(dataClass)) {
                System.out.println(" [Error] At least one class needs to be specified.");
                return 1;
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!GenericHelper.isNullOrEmpty(managementClass)) {
                allocCommand = allocCommand + " MGMTCLAS(" + managementClass + ")";
            }
            if (!GenericHelper.isNullOrEmpty(storageClass)) {
                allocCommand = allocCommand + " STORCLAS(" + storageClass + ")";
            }
            if (!GenericHelper.isNullOrEmpty(dataClass)) {
                allocCommand = allocCommand + " DATACLAS(" + dataClass + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Command: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            if (datasetName.contains("(")) {
                datasetName = MVSHelper.getGDGActualName(ddName);
                zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            }
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                this.outputProperties.put("DatasetName", datasetName);
                return 0;
            }
            System.out.println(" [Error] Failed to create dataset " + datasetName);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }
}

