/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilePathHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.urbancode.air.plugin.inputs.CleanupBackupFilesInputs;
import java.io.File;
import java.util.Properties;

public class CleanupBackupFiles {
    private final Properties inputProperties;

    public CleanupBackupFiles(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        try {
            CleanupBackupFilesInputs pluginInputs = new CleanupBackupFilesInputs(this.inputProperties);
            pluginInputs.validateInputs();
            String versionPathInDeployBasePath = DeploymentFilePathHelper.getVersionPathInDeployBasePath(pluginInputs.getDeployBasePath(), pluginInputs.getResourceId(), pluginInputs.getComponentName(), pluginInputs.getVersionName(), true);
            if (FileHelper.directoryExist(versionPathInDeployBasePath)) {
                this.checkDirectoryPermissions(versionPathInDeployBasePath);
                Console.printActionTitle("Cleaning up backup files from " + versionPathInDeployBasePath);
                FileHelper.cleanDir(versionPathInDeployBasePath);
            } else {
                System.out.println(" [Warning] Directory " + versionPathInDeployBasePath + " does not exist. No cleanup action run for " + pluginInputs.getVersionName());
            }
            System.out.println();
            return 0;
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private void checkDirectoryPermissions(String versionPathInDeployBasePath) {
        if (!new File(versionPathInDeployBasePath).canWrite()) {
            throw new IllegalArgumentException(" [Error] User does not have WRITE permission to delete backup files from directory " + versionPathInDeployBasePath);
        }
    }
}

