/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.teamz.build.ant.jni.ISPFStatistics;
import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.DsInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ReplaceTokensMVS {
    private Properties inputProperties;
    private Properties outputProperties;

    public ReplaceTokensMVS(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, Exception {
        block38: {
            String dirOffset = GenericHelper.isNullOrEmpty(this.inputProperties.getProperty("dir")) ? "." : this.inputProperties.getProperty("dir").trim();
            File currentDirectory = new File(".", dirOffset);
            Path workDirPath = Files.createTempDirectory(currentDirectory.toPath(), "replaceToken", new FileAttribute[0]);
            String workDir = workDirPath.toString();
            String includes = this.inputProperties.getProperty("includes").trim();
            Boolean isWildCardAllowed = Boolean.valueOf(this.inputProperties.getProperty("isWildCardAllowed").trim());
            Boolean failOnTruncate = Boolean.valueOf(this.inputProperties.getProperty("failOnTruncate").trim());
            String excludes = this.inputProperties.getProperty("excludes").trim();
            String startDelimiter = this.inputProperties.getProperty("startDelimiter").trim();
            String endDelimiter = this.inputProperties.getProperty("endDelimiter").trim();
            String propertyPrefix = this.inputProperties.getProperty("propertyPrefix").trim();
            String envPropValues = this.inputProperties.getProperty("envPropValues").trim();
            String explicitTokens = this.inputProperties.getProperty("explicitTokens").trim();
            LinkedHashSet<String> fileList = new LinkedHashSet<String>();
            try {
                String propValue;
                String propName;
                String[] parts;
                String PLUGIN_HOME = System.getenv("PLUGIN_HOME");
                System.setProperty("java.library.path", PLUGIN_HOME + "/lib/native:" + System.getProperty("java.library.path"));
                Properties properties = new Properties();
                if (!GenericHelper.isNullOrEmpty(envPropValues)) {
                    if (!GenericHelper.isNullOrEmpty(propertyPrefix)) {
                        System.out.println("Looking for properties starting with " + propertyPrefix);
                    }
                    String[] prop = envPropValues.split("(?<=(^|[^\\\\])(\\\\{2}){0,8}),");
                    for (int i = 0; i < prop.length; ++i) {
                        parts = prop[i].split("(?<=(^|[^\\\\])(\\\\{2}){0,8})=", 2);
                        propName = parts[0];
                        String string = propValue = parts.length == 2 ? parts[1] : "";
                        if (GenericHelper.isNullOrEmpty(propName)) continue;
                        propName = propName.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
                        propValue = propValue.replace("\\=", "=").replace("\\,", ",").replace("\\\\", "\\");
                        if (!GenericHelper.isNullOrEmpty(propertyPrefix) && !propName.startsWith(propertyPrefix)) continue;
                        propName = this.convertStringToDefaultEncoding(startDelimiter + propName + endDelimiter);
                        propValue = this.convertStringToDefaultEncoding(propValue);
                        properties.setProperty(propName, propValue);
                    }
                }
                if (!GenericHelper.isNullOrEmpty(explicitTokens)) {
                    BufferedReader reader = new BufferedReader(new StringReader(explicitTokens));
                    String line = reader.readLine();
                    while (line != null) {
                        parts = line.split("->", 2);
                        propName = parts[0];
                        propValue = parts.length == 2 ? parts[1] : "";
                        propName = this.convertStringToDefaultEncoding(propName);
                        propValue = this.convertStringToDefaultEncoding(propValue);
                        properties.setProperty(propName, propValue);
                        line = reader.readLine();
                    }
                }
                fileList.addAll(this.filter(includes, isWildCardAllowed, excludes));
                System.out.println("Replace token in following files:");
                Iterator file = fileList.iterator();
                while (file.hasNext()) {
                    System.out.println(ZFile.getFullyQualifiedDSN((String)file.next().toString()));
                }
                HashMap<String, Integer> fileStatus = new HashMap<String, Integer>();
                if (properties.size() > 0) {
                    Iterator it = fileList.iterator();
                    int noOfOccurences = 0;
                    int fileCnt = 0;
                    while (it.hasNext()) {
                        String dsnName = it.next().toString();
                        RecordReader reader = null;
                        File tempFile = new File(workDir, dsnName);
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), ZUtil.getDefaultPlatformEncoding());
                        StringBuilder fileDataBuilder = new StringBuilder();
                        String fileData = "";
                        try {
                            int bytesRead;
                            reader = RecordReader.newReader((String)dsnName, (int)1);
                            byte[] recordBuf = new byte[reader.getLrecl()];
                            String myRec = "";
                            while ((bytesRead = reader.read(recordBuf)) > 0) {
                                myRec = new String(recordBuf, 0, bytesRead, ZUtil.getDefaultPlatformEncoding());
                                fileDataBuilder.append(myRec).append("\n");
                            }
                            fileData = fileDataBuilder.toString();
                            int fileOccurences = 0;
                            Enumeration<?> enums = properties.propertyNames();
                            while (enums.hasMoreElements()) {
                                String rKey = (String)enums.nextElement();
                                String rValue = properties.getProperty(rKey);
                                fileOccurences += StringUtils.countMatches((CharSequence)fileData, (CharSequence)rKey);
                                fileData = StringUtils.replace((String)fileData, (String)rKey, (String)rValue);
                            }
                            writer.write(fileData);
                            fileStatus.put(dsnName, fileOccurences);
                            if (fileOccurences <= 0) continue;
                            ++fileCnt;
                            noOfOccurences += fileOccurences;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                        finally {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (ZFileException zfe) {
                                    zfe.printStackTrace();
                                    System.exit(1);
                                }
                            }
                            if (writer == null) continue;
                            try {
                                writer.flush();
                                writer.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.exit(1);
                            }
                        }
                    }
                    System.out.println("  [replace] Replaced " + noOfOccurences + " occurrences in " + fileCnt + " files.");
                    it = fileList.iterator();
                    while (it.hasNext()) {
                        String fileName = it.next().toString();
                        File tempFile = new File(workDir, fileName);
                        if ((Integer)fileStatus.get(fileName) <= 0) continue;
                        System.out.println("Apply changes to " + fileName);
                        ISPFStatistics ispfstats = this.getISPFStats(fileName);
                        RecordWriter target = RecordWriter.newWriter((String)fileName, (int)1);
                        BufferedReader output = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), ZUtil.getDefaultPlatformEncoding()));
                        byte[] recBuf = null;
                        int lineCounts = 1;
                        DsInfo dsInfo = new DsInfo(fileName);
                        boolean truncateOnCurrentFile = false;
                        try {
                            String line;
                            while ((line = output.readLine()) != null) {
                                String record = String.format("%-" + dsInfo.getAvailableRecordLength() + "s", line.replaceAll("\\s+$", ""));
                                recBuf = record.getBytes(ZUtil.getDefaultPlatformEncoding());
                                if (recBuf.length > dsInfo.getAvailableRecordLength()) {
                                    if (failOnTruncate.booleanValue()) {
                                        truncateOnCurrentFile = true;
                                    }
                                    System.out.println("Warning: line " + lineCounts + " of " + fileName + " excceeds " + dsInfo.getAvailableRecordLength() + " bytes and will be truncated.");
                                    System.out.println(" " + lineCounts + " of " + fileName + ": " + line);
                                    target.write(recBuf, 0, dsInfo.getAvailableRecordLength());
                                } else {
                                    target.write(recBuf, 0, recBuf.length);
                                }
                                ++lineCounts;
                            }
                            output.close();
                            tempFile.delete();
                            target.close();
                            if (ispfstats != null) {
                                this.updateISPFStats(ispfstats, --lineCounts, 0);
                            }
                            if (!failOnTruncate.booleanValue() || !truncateOnCurrentFile) continue;
                            System.out.println("Error: failed for truncated.");
                            System.exit(1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(1);
                        }
                    }
                    break block38;
                }
                System.out.println("No properties or explicit tokens to replace.");
            }
            catch (Exception e) {
                System.out.println("Error while executing program ");
                e.printStackTrace();
                System.exit(1);
            }
        }
        return 0;
    }

    public LinkedHashSet<String> filter(String include, Boolean allowWildCardIninclude, String exclude) throws Exception {
        String[] items;
        int i;
        String[] line;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!GenericHelper.isNullOrEmpty(include)) {
            line = include.split("\\s|,");
            for (i = 0; i < line.length; ++i) {
                String inputMBRPattern;
                items = new String[2];
                if (!GenericHelper.isNullOrEmpty(line[i])) {
                    items = line[i].split("\\(|\\)");
                }
                String includeDSPattern = items.length > 0 ? items[0] : "";
                String string = inputMBRPattern = items.length > 1 ? items[1] : "";
                if (!GenericHelper.isNullOrEmpty(includeDSPattern) && !allowWildCardIninclude.booleanValue() && includeDSPattern.contains("*")) {
                    System.out.println("Set Allow Wildcard to true to use wildcard(*) in Include Data Sets.");
                    this.outputProperties.setProperty("exitCode", "8");
                    this.outputProperties.setProperty("Status", "Failed");
                    System.exit(8);
                }
                if (!GenericHelper.isNullOrEmpty(inputMBRPattern) && !allowWildCardIninclude.booleanValue() && inputMBRPattern.contains("*")) {
                    System.out.println("Set Allow Wildcard to true to use wildcard(*) in Include Data Sets.");
                    this.outputProperties.setProperty("exitCode", "8");
                    this.outputProperties.setProperty("Status", "Failed");
                    System.exit(8);
                }
                if (GenericHelper.isNullOrEmpty(includeDSPattern)) continue;
                Map<String, String> dsHelper = DatasetHelper.searchNonVsamDataset(includeDSPattern);
                for (Map.Entry<String, String> mapElement : dsHelper.entrySet()) {
                    result.addAll(DatasetHelper.getMembers(mapElement.getKey().toString(), mapElement.getValue().toString(), inputMBRPattern));
                }
            }
        } else {
            System.out.println("Include cannot be empty");
            System.exit(1);
        }
        if (!GenericHelper.isNullOrEmpty(exclude)) {
            line = exclude.split("\\s|,");
            for (i = 0; i < line.length; ++i) {
                items = line[i].split("\\(|\\)");
                String excludeDSPattern = items.length > 0 ? items[0] : null;
                String excludeMBRPattern = items.length > 1 ? items[1] : "*";
                String pattern = DatasetHelper.makeRegexPattren(excludeDSPattern + "(" + excludeMBRPattern + ")");
                LinkedHashSet<String> deleteList = new LinkedHashSet<String>();
                for (String fileName : result) {
                    if (!fileName.matches("^.*" + pattern + ".*$")) continue;
                    deleteList.add(fileName);
                }
                result.removeAll(deleteList);
            }
        }
        return result;
    }

    public ISPFStatistics getISPFStats(String name) throws Exception {
        if (!name.startsWith("//'") || !name.endsWith(")'")) {
            return null;
        }
        name = name.substring(3, name.length() - 1);
        String dataset = name.substring(0, name.indexOf("("));
        String member = name.substring(name.indexOf("(") + 1, name.length() - 1);
        ISPFStatistics stats = new ISPFStatistics(dataset, member);
        return stats;
    }

    public boolean updateISPFStats(ISPFStatistics stats, int currentLines, int modifiedLines) {
        if (stats == null) {
            return false;
        }
        try {
            Calendar cal = Calendar.getInstance();
            stats.setModificationDate(cal.getTime());
            stats.setModifiedLines(modifiedLines);
            stats.setCurrentLines(currentLines);
            stats.setUserId(ZUtil.getCurrentUser());
            stats.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String convertStringToDefaultEncoding(String instr) throws UnsupportedEncodingException {
        byte[] chBytes = instr.getBytes(ZUtil.getDefaultPlatformEncoding());
        String encStr = new String(chBytes);
        return encStr;
    }
}

