/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.common.util.GenericHelper;
import com.ibm.urbancode.zos.common.util.TSOHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;

public class TsoIspf {
    public static void main(String[] args) {
        boolean ERR_CODE = true;
        try {
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String tsoCommand = inputProperties.getProperty("tsoCommand").trim();
            String ispfGatewayPath = inputProperties.getProperty("ispfGatewayPath").trim();
            boolean stopOnFail = Boolean.parseBoolean(inputProperties.getProperty("stopOnFail"));
            boolean reuseSession = Boolean.parseBoolean(inputProperties.getProperty("reuseSession"));
            boolean showLog = Boolean.parseBoolean(inputProperties.getProperty("showLog"));
            String serviceType = inputProperties.getProperty("serviceType").trim();
            String ispProf = inputProperties.getProperty("ispProf").trim();
            if (GenericHelper.isNullOrEmpty(tsoCommand)) {
                System.out.println(" [ERROR] Command To Run From ISPF cannot be empty.");
                System.exit(1);
            }
            if (GenericHelper.isNullOrEmpty(ispfGatewayPath)) {
                System.out.println(" [ERROR] ISPF Gateway Path cannot be empty.");
                System.exit(1);
            }
            TSOHelper tsoHelper = new TSOHelper(ispfGatewayPath, reuseSession, serviceType, ispProf);
            boolean success = true;
            BufferedReader reader = new BufferedReader(new StringReader(tsoCommand));
            String line = reader.readLine();
            while (line != null) {
                if (!success && stopOnFail) {
                    System.out.println(line);
                } else if (!GenericHelper.isNullOrEmpty(line)) {
                    TsoIspf.runTSOCommand(line, tsoHelper, showLog);
                    if (tsoHelper.getReturnCode() > 0) {
                        success = false;
                        line = reader.readLine();
                        if (!stopOnFail || line == null) continue;
                        System.out.println("Following commands are not executed because Stop On Fail is set to true.");
                        continue;
                    }
                }
                line = reader.readLine();
            }
            if (!success) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Error executing TSO/ISPF command: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void runTSOCommand(String tsoCommand, TSOHelper tsoHelper, boolean showLog) {
        System.out.println("===============================");
        System.out.println(tsoHelper.getServiceType() + " command: ");
        System.out.println(tsoCommand);
        int exitValue = tsoHelper.runCommand(tsoCommand);
        if (exitValue == 0) {
            System.out.println("===============================");
            System.out.println("Command output: ");
            if (tsoHelper.getServiceType().equals("ISPF") && tsoHelper.getReturnCode() > 0) {
                System.out.println("ISPF Gateway call failed with return code: " + tsoHelper.getReturnCode());
                System.out.println(tsoHelper.getReasonCode());
            }
            System.out.println(tsoHelper.getOutputText());
            if (showLog) {
                System.out.println("===============================");
                System.out.println("ISPF Gateway operations log");
                System.out.println(tsoHelper.getOperationsLog());
            }
        } else {
            System.out.println("Process exit code:  " + exitValue);
        }
        System.out.println("===============================");
        System.out.println();
    }
}

