/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;

public class Interceptor
extends PrintStream {
    private int lineCount;
    private static final String NEW_LINE = "\n";
    private static final int MAX_LINE_COUNT_FOR_FIRST_PAGE = 999;
    private static final int MAX_LINE_COUNT_FOR_LATER_PAGES = 1000;

    public Interceptor(OutputStream out, int lineCount) {
        super(out, true);
        this.lineCount = lineCount;
    }

    @Override
    public void print(String s) {
        super.print(s);
    }

    @Override
    public void println(String s) {
        if (s == null) {
            s = "";
        }
        if (s.contains(NEW_LINE)) {
            this.lineCount += StringUtils.countMatches((CharSequence)s, (CharSequence)NEW_LINE);
        } else if (s.contains("=================================== Submitting")) {
            int noOfNewLinesToBeAdded = this.lineCount <= 999 ? 999 - this.lineCount : 1000 - (this.lineCount - 999) % 1000;
            this.lineCount += noOfNewLinesToBeAdded;
            String newLines = StringUtils.repeat((String)NEW_LINE, (int)noOfNewLinesToBeAdded);
            System.out.print(newLines);
        }
        ++this.lineCount;
        super.println(s);
    }
}

