/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnv;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class GenericHelper {
    private static final String CONF = "conf";
    public static final String TOOLKIT = "toolkit";
    public static final String BINARY_VERSION = "binary.version";
    public static final String INSTALLED_VERSION = "installed.version";

    private GenericHelper() {
        throw new IllegalStateException("Utility class, has only static methods");
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static int getAgentToolkitVersion() throws IOException {
        String toolkitBinaryVersionFilePath = SystemEnv.getBuzToolkitHome() + File.separator + CONF + File.separator + TOOLKIT + File.separator + BINARY_VERSION;
        File toolkitBinaryVersionFile = new File(toolkitBinaryVersionFilePath);
        Properties toolkitProp = new Properties();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(toolkitBinaryVersionFile));){
            toolkitProp.load(bufferedReader);
        }
        String installedVersion = toolkitProp.getProperty(INSTALLED_VERSION);
        if (GenericHelper.isNullOrEmpty(installedVersion)) {
            throw new RuntimeException("Unable to get toolkit version");
        }
        return Integer.parseInt(installedVersion.trim().replace(".", ""));
    }
}

